/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MalformedSetUpTearDownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("malformed.set.up.tear.down.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("malformed.set.up.tear.down.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedSetUpTearDownVisitor();
    }

    private static class MalformedSetUpTearDownVisitor
    extends BaseInspectionVisitor {
        private MalformedSetUpTearDownVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            String methodName = method2.getName();
            if (!"setUp".equals(methodName) && !"tearDown".equals(methodName)) {
                return;
            }
            PsiClass targetClass = method2.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase")) {
                return;
            }
            if (method2.getParameterList().getParametersCount() != 0 || !PsiType.VOID.equals((Object)method2.getReturnType()) || !method2.hasModifierProperty("public") && !method2.hasModifierProperty("protected")) {
                this.registerMethodError(method2, new Object[0]);
            }
        }
    }
}

