/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceAssertEqualsFix
extends InspectionGadgetsFix {
    private final String myMethodName;

    public ReplaceAssertEqualsFix(String methodName) {
        this.myMethodName = methodName;
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("replace.assertequals.quickfix", this.myMethodName);
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
        PsiElement grandParent = methodExpression.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null && ImportUtils.addStaticImport(className, this.myMethodName, (PsiElement)methodExpression)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, this.myMethodName);
        } else {
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, StringUtil.getQualifiedName((String)className, (String)this.myMethodName));
        }
    }
}

