/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StaticSuiteInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SuiteNotDeclaredStatic";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.suite.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("static.suite.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticSuiteVisitor();
    }

    private static class StaticSuiteVisitor
    extends BaseInspectionVisitor {
        private StaticSuiteVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            String methodName = method2.getName();
            if (!"suite".equals(methodName)) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (method2.hasModifierProperty("static")) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }
    }
}

