/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseWithNoTestMethodsInspection
extends BaseInspection {
    public boolean ignoreSupers = false;

    @NotNull
    public String getID() {
        return "JUnitTestCaseWithNoTests";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("test.case.with.no.test.methods.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("test.case.with.no.test.methods.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("test.case.with.no.test.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSupers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithNoTestMethodsVisitor();
    }

    private class TestCaseWithNoTestMethodsVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithNoTestMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass superClass;
            PsiMethod[] methods;
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase")) {
                return;
            }
            for (PsiMethod method2 : methods = aClass.getMethods()) {
                if (!TestUtils.isJUnitTestMethod(method2)) continue;
                return;
            }
            if (TestCaseWithNoTestMethodsInspection.this.ignoreSupers && (superClass = aClass.getSuperClass()) != null) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = superClass.getMethods()) {
                    if (!TestUtils.isJUnitTestMethod(superMethod)) continue;
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

