/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TestMethodIsPublicVoidNoArgInspectionBase
extends BaseInspection {
    public final List<String> ignorableAnnotations = new ArrayList<String>(Arrays.asList("mockit.Mocked"));

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "TestMethodWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Problem problem = (Problem)((Object)infos[0]);
        switch (problem) {
            case PARAMETER: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor1", new Object[0]);
            }
            case NOT_PUBLIC_VOID: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor2", new Object[0]);
            }
            case STATIC: {
                return InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor3", new Object[0]);
            }
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodIsPublicVoidNoArgVisitor();
    }

    private class TestMethodIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TestMethodIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiType returnType;
            if (method2.isConstructor()) {
                return;
            }
            if (!TestUtils.isJUnit3TestMethod(method2) && !TestUtils.isJUnit4TestMethod(method2)) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null || AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.junit.runner.RunWith", (boolean)true)) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (method2.hasModifierProperty("static")) {
                this.registerMethodError(method2, new Object[]{Problem.STATIC, method2});
                return;
            }
            if (parameterList.getParametersCount() != 0) {
                PsiParameter[] parameters2 = parameterList.getParameters();
                boolean annotated = true;
                for (PsiParameter parameter : parameters2) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, TestMethodIsPublicVoidNoArgInspectionBase.this.ignorableAnnotations)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) {
                    this.registerMethodError(method2, new Object[]{Problem.PARAMETER, method2});
                    return;
                }
            }
            if (!PsiType.VOID.equals((Object)(returnType = method2.getReturnType())) || !method2.hasModifierProperty("public")) {
                this.registerMethodError(method2, new Object[]{Problem.NOT_PUBLIC_VOID, method2});
            }
        }
    }

    static enum Problem {
        STATIC,
        NOT_PUBLIC_VOID,
        PARAMETER;

    }
}

