/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UnconstructableTestCaseInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "UnconstructableJUnitTestCase";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unconstructable.test.case.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unconstructable.test.case.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconstructableTestCaseVisitor();
    }

    private static class UnconstructableTestCaseVisitor
    extends BaseInspectionVisitor {
        private UnconstructableTestCaseVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (TestUtils.isJUnit4TestClass(aClass, false)) {
                PsiMethod[] constructors = aClass.getConstructors();
                if (constructors.length == 0) {
                    return;
                }
                if (constructors.length == 1) {
                    PsiMethod constructor = constructors[0];
                    PsiParameterList parameterList = constructor.getParameterList();
                    if (constructor.hasModifierProperty("public") && parameterList.getParametersCount() == 0) {
                        return;
                    }
                }
            } else if (TestUtils.isJUnitTestClass(aClass)) {
                PsiMethod[] constructors = aClass.getConstructors();
                boolean hasStringConstructor = false;
                boolean hasNoArgConstructor = false;
                boolean hasConstructor = false;
                for (PsiMethod constructor : constructors) {
                    PsiParameter[] parameters2;
                    PsiType type2;
                    hasConstructor = true;
                    if (!constructor.hasModifierProperty("public")) continue;
                    PsiParameterList parameterList = constructor.getParameterList();
                    int parametersCount = parameterList.getParametersCount();
                    if (parametersCount == 0) {
                        hasNoArgConstructor = true;
                    }
                    if (parametersCount != 1 || !TypeUtils.typeEquals("java.lang.String", type2 = (parameters2 = parameterList.getParameters())[0].getType())) continue;
                    hasStringConstructor = true;
                }
                if (!hasConstructor) {
                    return;
                }
                if (hasNoArgConstructor || hasStringConstructor) {
                    return;
                }
            } else {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

