/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SerializationFilterBase;
import com.intellij.util.xmlb.XmlSerializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerInitializedWithForeignClassInspectionBase
extends BaseInspection {
    @NonNls
    private static final String DEFAULT_LOGGER_CLASS_NAMES = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger";
    @NonNls
    private static final String DEFAULT_FACTORY_METHOD_NAMES = "getLogger,getLogger,getLog,getLogger";
    protected final List<String> loggerFactoryClassNames = new ArrayList<String>();
    protected final List<String> loggerFactoryMethodNames = new ArrayList<String>();
    public String loggerClassName = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger";
    public String loggerFactoryMethodName = "getLogger,getLogger,getLog,getLogger";

    public LoggerInitializedWithForeignClassInspectionBase() {
        LoggerInitializedWithForeignClassInspectionBase.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspectionBase.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoggerInitializedWithForeignClassFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggerInitializedWithForeignClassVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        LoggerInitializedWithForeignClassInspectionBase.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspectionBase.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
        if (this.loggerFactoryClassNames.size() != this.loggerFactoryMethodNames.size() || this.loggerFactoryClassNames.isEmpty()) {
            LoggerInitializedWithForeignClassInspectionBase.parseString(DEFAULT_LOGGER_CLASS_NAMES, this.loggerFactoryClassNames);
            LoggerInitializedWithForeignClassInspectionBase.parseString(DEFAULT_FACTORY_METHOD_NAMES, this.loggerFactoryMethodNames);
        }
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerClassName = LoggerInitializedWithForeignClassInspectionBase.formatString(this.loggerFactoryClassNames);
        this.loggerFactoryMethodName = LoggerInitializedWithForeignClassInspectionBase.formatString(this.loggerFactoryMethodNames);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)new SerializationFilterBase(){

            protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
                if ("loggerClassName".equals(accessor.getName()) && LoggerInitializedWithForeignClassInspectionBase.DEFAULT_LOGGER_CLASS_NAMES.equals(beanValue)) {
                    return false;
                }
                return !"loggerFactoryMethodNames".equals(accessor.getName()) || !LoggerInitializedWithForeignClassInspectionBase.DEFAULT_FACTORY_METHOD_NAMES.equals(beanValue);
            }
        });
    }

    private class LoggerInitializedWithForeignClassVisitor
    extends BaseInspectionVisitor {
        private LoggerInitializedWithForeignClassVisitor() {
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
            super.visitClassObjectAccessExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
                if (!expression2.equals(referenceExpression.getQualifierExpression())) {
                    return;
                }
                String name = referenceExpression.getReferenceName();
                if (!"getName".equals(name)) {
                    return;
                }
                PsiElement grandParent = referenceExpression.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiExpressionList list = methodCallExpression.getArgumentList();
                if (list.getExpressions().length != 0) {
                    return;
                }
                parent = methodCallExpression.getParent();
            }
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            while (containingClass instanceof PsiAnonymousClass) {
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            }
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getName();
            if (containingClassName == null) {
                return;
            }
            PsiMethod method2 = methodCallExpression.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            int index = LoggerInitializedWithForeignClassInspectionBase.this.loggerFactoryClassNames.indexOf(className);
            if (index < 0) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            String loggerFactoryMethodName = LoggerInitializedWithForeignClassInspectionBase.this.loggerFactoryMethodNames.get(index);
            if (!loggerFactoryMethodName.equals(referenceName)) {
                return;
            }
            PsiTypeElement operand2 = expression2.getOperand();
            PsiType type2 = operand2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass initializerClass = classType.resolve();
            if (initializerClass == null) {
                return;
            }
            if (containingClass.equals(initializerClass)) {
                return;
            }
            this.registerError((PsiElement)expression2, containingClassName);
        }
    }

    private static class LoggerInitializedWithForeignClassFix
    extends InspectionGadgetsFix {
        private final String newClassName;

        private LoggerInitializedWithForeignClassFix(String newClassName) {
            this.newClassName = newClassName;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.quickfix", this.newClassName);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace foreign class";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)classObjectAccessExpression, this.newClassName + ".class");
        }
    }
}

