/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.ui.JBUI;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.maturity.SuppressionAnnotationInspectionBase;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SuppressionAnnotationInspection
extends SuppressionAnnotationInspectionBase {
    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore suppressions", this.myAllowedSuppressions);
        JComponent panel2 = form.getContentPanel();
        panel2.setPreferredSize((Dimension)JBUI.size((int)150, (int)100));
        return panel2;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        boolean suppressionIdPresent = (Boolean)infos[1];
        if (infos[0] instanceof PsiAnnotation) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray;
            PsiAnnotation annotation = (PsiAnnotation)infos[0];
            if (suppressionIdPresent) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray2 = new InspectionGadgetsFix[2];
                inspectionGadgetsFixArray2[0] = new DelegatingFix(new RemoveAnnotationQuickFix(annotation, null));
                inspectionGadgetsFixArray = inspectionGadgetsFixArray2;
                inspectionGadgetsFixArray2[1] = new AllowSuppressionsFix();
            } else {
                InspectionGadgetsFix[] inspectionGadgetsFixArray3 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray = inspectionGadgetsFixArray3;
                inspectionGadgetsFixArray3[0] = new DelegatingFix(new RemoveAnnotationQuickFix(annotation, null));
            }
            return inspectionGadgetsFixArray;
        }
        if (infos[0] instanceof PsiComment) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray;
            if (suppressionIdPresent) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray4 = new InspectionGadgetsFix[2];
                inspectionGadgetsFixArray4[0] = new RemoveSuppressCommentFix();
                inspectionGadgetsFixArray = inspectionGadgetsFixArray4;
                inspectionGadgetsFixArray4[1] = new AllowSuppressionsFix();
            } else {
                InspectionGadgetsFix[] inspectionGadgetsFixArray5 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray = inspectionGadgetsFixArray5;
                inspectionGadgetsFixArray5[0] = new RemoveSuppressCommentFix();
            }
            return inspectionGadgetsFixArray;
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    private class AllowSuppressionsFix
    extends InspectionGadgetsFix {
        private AllowSuppressionsFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            Iterable<String> ids;
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiAnnotation) {
                ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)psiElement.getParent());
            } else {
                String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn(psiElement);
                if (suppressedIds == null) {
                    return;
                }
                ids = StringUtil.tokenize((String)suppressedIds, (String)",");
            }
            for (String id : ids) {
                if (SuppressionAnnotationInspection.this.myAllowedSuppressions.contains(id)) continue;
                SuppressionAnnotationInspection.this.myAllowedSuppressions.add(id);
            }
            ProjectInspectionProfileManager.getInstance(project2).fireProfileChanged();
        }

        @NotNull
        public String getName() {
            return "Allow these suppressions";
        }

        @NotNull
        public String getFamilyName() {
            return "Allow suppressions";
        }
    }

    private static class RemoveSuppressCommentFix
    extends InspectionGadgetsFix {
        private RemoveSuppressCommentFix() {
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement != null) {
                psiElement.delete();
            }
        }

        @NotNull
        public String getFamilyName() {
            return "Remove //noinspection";
        }
    }
}

