/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressionAnnotationInspectionBase
extends BaseInspection {
    public List<String> myAllowedSuppressions = new ArrayList<String>();

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("inspection.suppression.annotation.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("inspection.suppression.annotation.problem.descriptor", new Object[0]);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuppressionAnnotationVisitor();
    }

    private class SuppressionAnnotationVisitor
    extends BaseInspectionVisitor {
        private SuppressionAnnotationVisitor() {
        }

        public void visitComment(PsiComment comment) {
            super.visitComment(comment);
            IElementType tokenType = comment.getTokenType();
            if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT) && !tokenType.equals(JavaTokenType.C_STYLE_COMMENT)) {
                return;
            }
            String commentText = comment.getText();
            if (commentText.length() <= 2) {
                return;
            }
            String strippedComment = commentText.substring(2).trim();
            if (!strippedComment.startsWith("noinspection")) {
                return;
            }
            String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment);
            if (suppressedIds == null) {
                this.registerError((PsiElement)comment, comment, Boolean.FALSE);
                return;
            }
            Iterable ids = StringUtil.tokenize((String)suppressedIds, (String)",");
            for (String id : ids) {
                if (SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.contains(id)) continue;
                this.registerError((PsiElement)comment, comment, Boolean.TRUE);
                break;
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiElement annotationParent;
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            String text = reference.getText();
            if (("SuppressWarnings".equals(text) || "java.lang.SuppressWarnings".equals(text)) && (annotationParent = annotation.getParent()) instanceof PsiModifierList) {
                Collection<String> ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)annotationParent);
                if (!SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.containsAll(ids)) {
                    this.registerError((PsiElement)annotation, annotation, Boolean.TRUE);
                } else if (ids.isEmpty()) {
                    this.registerError((PsiElement)annotation, annotation, Boolean.FALSE);
                }
            }
        }
    }
}

