/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfInnerClassInspection
extends BaseInspection {
    public boolean ignoreNonPublic = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("return.of.inner.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        switch ((ClassType)((Object)infos[0])) {
            case ANONYMOUS_CLASS: {
                return InspectionGadgetsBundle.message("return.of.anonymous.class.problem.descriptor", new Object[0]);
            }
            case LOCAL_CLASS: {
                PsiClass aClass = (PsiClass)infos[1];
                return InspectionGadgetsBundle.message("return.of.local.class.problem.descriptor", aClass.getName());
            }
            case INNER_CLASS: {
                PsiClass aClass = (PsiClass)infos[1];
                return InspectionGadgetsBundle.message("return.of.inner.class.problem.descriptor", aClass.getName());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.inner.class.ignore.non.public.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonPublic");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfInnerClassVisitor();
    }

    private class ReturnOfInnerClassVisitor
    extends BaseInspectionVisitor {
        private ReturnOfInnerClassVisitor() {
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            super.visitReturnStatement(statement2);
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(statement2.getReturnValue());
            if (expression2 == null) {
                return;
            }
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method2 == null || method2.hasModifierProperty("private") || method2.hasModifierProperty("static")) {
                return;
            }
            if (ReturnOfInnerClassInspection.this.ignoreNonPublic && (method2.hasModifierProperty("protected") || method2.hasModifierProperty("packageLocal"))) {
                return;
            }
            if (expression2 instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)expression2).getAnonymousClass()) != null) {
                this.registerStatementError((PsiStatement)statement2, new Object[]{ClassType.ANONYMOUS_CLASS});
                return;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (PsiUtil.isLocalClass((PsiClass)aClass)) {
                this.registerStatementError((PsiStatement)statement2, new Object[]{ClassType.LOCAL_CLASS, aClass});
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null || aClass.hasModifierProperty("static")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[]{ClassType.INNER_CLASS, aClass});
        }
    }

    private static enum ClassType {
        ANONYMOUS_CLASS,
        LOCAL_CLASS,
        INNER_CLASS;

    }
}

