/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "OverlyComplexMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cyclomatic.complexity.display.name", new Object[0]);
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer complexity = (Integer)infos[0];
        return InspectionGadgetsBundle.message("cyclomatic.complexity.problem.descriptor", complexity);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodComplexityVisitor();
    }

    private class MethodComplexityVisitor
    extends BaseInspectionVisitor {
        private MethodComplexityVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2.getNameIdentifier() == null) {
                return;
            }
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            method2.accept((PsiElementVisitor)visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= CyclomaticComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method2, complexity);
        }
    }
}

