/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "OverlyNestedMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("nesting.depth.display.name", new Object[0]);
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("nesting.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer nestingDepth = (Integer)infos[0];
        return InspectionGadgetsBundle.message("nesting.depth.problem.descriptor", nestingDepth);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestingDepthMethodVisitor();
    }

    private class NestingDepthMethodVisitor
    extends BaseInspectionVisitor {
        private NestingDepthMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2.getNameIdentifier() == null) {
                return;
            }
            NestingDepthVisitor visitor = new NestingDepthVisitor(NestingDepthInspection.this.getLimit());
            method2.accept((PsiElementVisitor)visitor);
            int count = visitor.getMaximumDepth();
            if (count <= NestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method2, count);
        }
    }
}

