/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final int myLimit;
    private int m_maximumDepth;
    private int m_currentDepth;
    private final Set<PsiElement> scopeEntered = new THashSet();

    public NestingDepthVisitor(int limit) {
        this.myLimit = limit;
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
    }

    public void visitBlockStatement(PsiBlockStatement statement2) {
        boolean isAlreadyCounted;
        PsiElement parent = statement2.getParent();
        boolean bl = isAlreadyCounted = parent instanceof PsiDoWhileStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiIfStatement || parent instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement2);
        }
        super.visitBlockStatement(statement2);
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitDoWhileStatement(statement2);
    }

    public void visitForStatement(@NotNull PsiForStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitForStatement(statement2);
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement2) {
        PsiStatement elseBranch;
        boolean isAlreadyCounted = false;
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiIfStatement && statement2.equals(elseBranch = ((PsiIfStatement)parent).getElseBranch())) {
            isAlreadyCounted = true;
        }
        if (!isAlreadyCounted) {
            this.enterScope((PsiElement)statement2);
        }
        super.visitIfStatement(statement2);
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitSynchronizedStatement(statement2);
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitTryStatement(statement2);
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitSwitchStatement(statement2);
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
        this.enterScope((PsiElement)statement2);
        super.visitWhileStatement(statement2);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        this.exitScope(element);
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
        if (this.m_maximumDepth > this.myLimit) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.m_currentDepth;
        }
    }

    int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

