/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    public boolean checkNotNull;
    private static final EquivalenceChecker EQUIVALENCE = new NoSideEffectExpressionEquivalenceChecker();

    @NotNull
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.replaceable.by.objects.check.not.null.option", new Object[0]), (InspectionProfileEntry)this, "checkNotNull");
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualsReplaceableByObjectsCallFix((String)infos[0], (String)infos[1], (Boolean)infos[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private static PsiExpression getArgumentExpression(PsiMethodCallExpression callExpression) {
        PsiExpression[] expressions2 = callExpression.getArgumentList().getExpressions();
        return expressions2.length == 1 ? ParenthesesUtils.stripParentheses(expressions2[0]) : null;
    }

    private static PsiExpression getQualifierExpression(PsiMethodCallExpression expression2) {
        return ParenthesesUtils.stripParentheses(expression2.getMethodExpression().getQualifierExpression());
    }

    private static class NoSideEffectExpressionEquivalenceChecker
    extends EquivalenceChecker {
        private NoSideEffectExpressionEquivalenceChecker() {
        }

        @Override
        protected EquivalenceChecker.Decision newExpressionsAreEquivalentDecision(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
            return EXACTLY_UN_MATCHES;
        }

        @Override
        protected EquivalenceChecker.Decision methodCallExpressionsAreEquivalentDecision(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
            return EXACTLY_UN_MATCHES;
        }

        @Override
        protected EquivalenceChecker.Decision assignmentExpressionsAreEquivalentDecision(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
            return EXACTLY_UN_MATCHES;
        }

        @Override
        protected EquivalenceChecker.Decision arrayInitializerExpressionsAreEquivalentDecision(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
            return EXACTLY_UN_MATCHES;
        }

        @Override
        protected EquivalenceChecker.Decision prefixExpressionsAreEquivalentDecision(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(prefixExpression1.getOperationTokenType())) {
                return EXACTLY_UN_MATCHES;
            }
            return super.prefixExpressionsAreEquivalentDecision(prefixExpression1, prefixExpression2);
        }

        @Override
        protected EquivalenceChecker.Decision postfixExpressionsAreEquivalentDecision(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(postfixExpression1.getOperationTokenType())) {
                return EXACTLY_UN_MATCHES;
            }
            return super.postfixExpressionsAreEquivalentDecision(postfixExpression1, postfixExpression2);
        }

        private static boolean isSideEffectUnaryOperator(IElementType tokenType) {
            return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
        }
    }

    private static class EqualsCheck {
        @NotNull
        final PsiExpression argument;
        @NotNull
        final PsiExpression qualifier;
        final boolean isEqual;

        public EqualsCheck(@NotNull PsiExpression argument, @NotNull PsiExpression qualifier, boolean isEqual) {
            this.argument = argument;
            this.qualifier = qualifier;
            this.isEqual = isEqual;
        }

        @Nullable
        private static EqualsCheck create(@Nullable PsiExpression maybeEqualsCheckExpression) {
            PsiMethodCallExpression callExpression;
            Negated n = Negated.create(maybeEqualsCheckExpression);
            if (n != null && n.expression instanceof PsiMethodCallExpression && "equals".equals((callExpression = (PsiMethodCallExpression)n.expression).getMethodExpression().getReferenceName())) {
                PsiExpression argument = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(callExpression);
                PsiExpression qualifier = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(callExpression);
                if (argument != null && qualifier != null) {
                    return new EqualsCheck(argument, qualifier, n.isEqual);
                }
            }
            return null;
        }
    }

    private static class NullCheck {
        @NotNull
        final PsiExpression compared;
        final boolean isEqual;

        public NullCheck(@NotNull PsiExpression compared, boolean isEqual) {
            this.compared = compared;
            this.isEqual = isEqual;
        }

        @Nullable
        private static NullCheck create(@Nullable PsiExpression maybeNullCheckExpression) {
            PsiBinaryExpression binaryExpression;
            PsiExpression comparedWithNull;
            Negated n = Negated.create(maybeNullCheckExpression);
            if (n != null && n.expression instanceof PsiBinaryExpression && (comparedWithNull = ParenthesesUtils.stripParentheses(ExpressionUtils.getValueComparedWithNull(binaryExpression = (PsiBinaryExpression)n.expression))) != null) {
                boolean equal = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType());
                return new NullCheck(comparedWithNull, equal == n.isEqual);
            }
            return null;
        }
    }

    private static class Negated {
        @NotNull
        final PsiExpression expression;
        final boolean isEqual;

        public Negated(@NotNull PsiExpression expression2, boolean isEqual) {
            this.expression = expression2;
            this.isEqual = isEqual;
        }

        @Nullable
        static Negated create(@Nullable PsiExpression maybeNegatedExpression) {
            PsiPrefixExpression prefixExpression;
            boolean equal = true;
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(maybeNegatedExpression);
            if (expression2 instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixExpression = (PsiPrefixExpression)expression2).getOperationTokenType())) {
                equal = false;
                expression2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            }
            return expression2 != null ? new Negated(expression2, equal) : null;
        }
    }

    private class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            String methodName = expression2.getMethodExpression().getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression2 = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(expression2);
            if (qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
                return;
            }
            PsiElement parentExpression = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiPrefixExpression.class});
            if (parentExpression instanceof PsiBinaryExpression ? this.processNotNullCheck((PsiBinaryExpression)parentExpression) : parentExpression instanceof PsiConditionalExpression && this.processNotNullCondition((PsiConditionalExpression)parentExpression)) {
                return;
            }
            if (!EqualsReplaceableByObjectsCallInspection.this.checkNotNull) {
                if (qualifierExpression2 == null) {
                    return;
                }
                PsiExpression argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(expression2);
                if (argumentExpression == null) {
                    return;
                }
                this.registerError((PsiElement)expression2, qualifierExpression2.getText(), argumentExpression.getText(), true);
            }
        }

        private boolean processNotNullCheck(PsiBinaryExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            PsiExpression rightOperand2 = ParenthesesUtils.stripParentheses(expression2.getROperand());
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                return this.registerProblem(expression2, rightOperand2, true);
            }
            if (JavaTokenType.OROR.equals(tokenType) && rightOperand2 instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)rightOperand2).getOperationTokenType())) {
                PsiExpression negatedRightOperand = ParenthesesUtils.stripParentheses(((PsiPrefixExpression)rightOperand2).getOperand());
                return this.registerProblem(expression2, negatedRightOperand, false);
            }
            return true;
        }

        private boolean processNotNullCondition(@NotNull PsiConditionalExpression expression2) {
            NullCheck conditionNullCheck = NullCheck.create(expression2.getCondition());
            if (conditionNullCheck == null) {
                return false;
            }
            PsiExpression nullBranch = conditionNullCheck.isEqual ? expression2.getThenExpression() : expression2.getElseExpression();
            PsiExpression nonNullBranch = conditionNullCheck.isEqual ? expression2.getElseExpression() : expression2.getThenExpression();
            NullCheck otherNullCheck = NullCheck.create(nullBranch);
            EqualsCheck equalsCheck = EqualsCheck.create(nonNullBranch);
            if (otherNullCheck == null || equalsCheck == null || otherNullCheck.isEqual != equalsCheck.isEqual) {
                return false;
            }
            if (EQUIVALENCE.expressionsAreEquivalent(conditionNullCheck.compared, equalsCheck.qualifier) && EQUIVALENCE.expressionsAreEquivalent(otherNullCheck.compared, equalsCheck.argument)) {
                this.registerError((PsiElement)expression2, equalsCheck.qualifier.getText(), equalsCheck.argument.getText(), equalsCheck.isEqual);
                return true;
            }
            return false;
        }

        private boolean registerProblem(@NotNull PsiBinaryExpression expression2, PsiExpression rightOperand2, boolean equal) {
            if (rightOperand2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)rightOperand2;
                NullCheck nullCheck = NullCheck.create(expression2.getLOperand());
                if (nullCheck != null && nullCheck.isEqual != equal) {
                    PsiExpression argumentExpression;
                    PsiExpression nullCheckedExpression = nullCheck.compared;
                    PsiExpression qualifierExpression2 = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(methodCallExpression);
                    if (EQUIVALENCE.expressionsAreEquivalent(qualifierExpression2, nullCheckedExpression) && (argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(methodCallExpression)) != null) {
                        PsiExpression expressionToReplace = this.checkEqualityBefore((PsiExpression)expression2, equal, qualifierExpression2, argumentExpression);
                        this.registerError((PsiElement)expressionToReplace, nullCheckedExpression.getText(), argumentExpression.getText(), equal);
                        return true;
                    }
                }
            }
            return false;
        }

        @NotNull
        private PsiExpression checkEqualityBefore(@NotNull PsiExpression expression2, boolean equal, PsiExpression part1, PsiExpression part2) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression lhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if ((equal && JavaTokenType.OROR.equals(tokenType) || !equal && JavaTokenType.ANDAND.equals(tokenType)) && PsiTreeUtil.isAncestor((PsiElement)binaryExpression.getROperand(), (PsiElement)expression2, (boolean)false) && this.isEquality(lhs = binaryExpression.getLOperand(), equal, part1, part2)) {
                    return binaryExpression;
                }
            }
            return expression2;
        }

        private boolean isEquality(PsiExpression expression2, boolean equals, PsiExpression part1, PsiExpression part2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression leftOperand2 = binaryExpression.getLOperand();
            PsiExpression rightOperand2 = binaryExpression.getROperand();
            return EQUIVALENCE.expressionsAreEquivalent(leftOperand2, part1) && EQUIVALENCE.expressionsAreEquivalent(rightOperand2, part2) || EQUIVALENCE.expressionsAreEquivalent(leftOperand2, part2) && EQUIVALENCE.expressionsAreEquivalent(rightOperand2, part1);
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression || element instanceof PsiMethodCallExpression || element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            String expressionText = "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")";
            PsiReplacementUtil.replaceExpressionAndShorten(expression2, this.myEquals != false ? expressionText : "!" + expressionText);
        }
    }
}

