/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    private static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedOutsideContextVisitor visitor = new VariableUsedOutsideContextVisitor(variable, context);
        PsiElement declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept((PsiElementVisitor)visitor);
        return visitor.variableIsUsed();
    }

    private static List<PsiLocalVariable> collectVariables(PsiTryStatement tryStatement) {
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return Collections.emptyList();
        }
        PsiStatement[] statements = finallyBlock.getStatements();
        if (statements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PsiLocalVariable> variables = new ArrayList<PsiLocalVariable>();
        for (PsiStatement statement2 : statements) {
            PsiLocalVariable variable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(statement2);
            if (variable == null) continue;
            variables.add(variable);
        }
        Collections.sort(variables, PsiElementOrderComparator.getInstance());
        return variables;
    }

    @Nullable
    private static PsiLocalVariable findAutoCloseableVariable(PsiStatement statement2) {
        if (statement2 instanceof PsiIfStatement) {
            PsiLocalVariable resourceVariable;
            PsiLocalVariable variable;
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (!(condition2 instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return null;
            }
            if (PsiType.NULL.equals((Object)rhs.getType())) {
                variable = TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(lhs);
            } else if (PsiType.NULL.equals((Object)lhs.getType())) {
                variable = TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(rhs);
            } else {
                return null;
            }
            if (variable == null) {
                return null;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(ControlFlowUtils.getOnlyStatementInBlock(codeBlock));
            } else {
                return null;
            }
            if (variable.equals(resourceVariable)) {
                return resourceVariable;
            }
        } else if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"close".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable) || target instanceof PsiResourceVariable) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)target;
            if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable((PsiVariable)variable)) {
                return null;
            }
            return variable;
        }
        return null;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiType type2 = variable.getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AutoCloseable");
    }

    private static int findInitialization(PsiElement[] elements, PsiVariable variable, boolean hasInitializer) {
        int result2 = -1;
        int statementsLength = elements.length;
        for (int i2 = 0; i2 < statementsLength; ++i2) {
            PsiElement element = elements[i2];
            if (TryFinallyCanBeTryWithResourcesInspection.isNormalAssignment(element, variable)) {
                if (result2 >= 0 && !hasInitializer) {
                    return -1;
                }
                if (hasInitializer) {
                    return i2;
                }
                result2 = i2;
                continue;
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, element)) continue;
            return hasInitializer ? i2 : -1;
        }
        return result2;
    }

    private static boolean isNormalAssignment(PsiElement element, PsiVariable variable) {
        if (!(element instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
        PsiExpression lhs = assignmentExpression.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
        PsiElement target = referenceExpression.resolve();
        return variable.equals(target);
    }

    private static PsiLocalVariable resolveLocalVariable(PsiExpression expression2) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        return !(target instanceof PsiLocalVariable) ? null : (PsiLocalVariable)target;
    }

    private static class VariableUsedOutsideContextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean used;
        @NotNull
        private final PsiVariable variable;
        private final PsiElement skipContext;

        public VariableUsedOutsideContextVisitor(@NotNull PsiVariable variable, PsiElement skipContext) {
            this.variable = variable;
            this.skipContext = skipContext;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element.equals(this.skipContext)) {
                return;
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals(this.variable) && !VariableUsedOutsideContextVisitor.isCloseMethodCalled(referenceExpression)) {
                this.used = true;
            }
        }

        private static boolean isCloseMethodCalled(PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        public boolean variableIsUsed() {
            return this.used;
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement tryStatement) {
            super.visitTryStatement(tryStatement);
            PsiResourceList resourceList = tryStatement.getResourceList();
            if (resourceList != null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            List variables = TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement);
            if (variables.isEmpty()) {
                return;
            }
            PsiStatement[] tryBlockStatements = tryBlock.getStatements();
            Iterator iterator = variables.iterator();
            while (iterator.hasNext()) {
                PsiType type2;
                PsiVariable variable;
                PsiExpression initializer = (variable = (PsiVariable)iterator.next()).getInitializer();
                boolean hasInitializer = initializer == null ? false : !PsiType.NULL.equals((Object)(type2 = initializer.getType()));
                int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization((PsiElement[])tryBlockStatements, variable, hasInitializer);
                if (index >= 0 != hasInitializer && !TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext(variable, (PsiElement)tryBlock)) continue;
                return;
            }
            this.registerStatementError((PsiStatement)tryStatement, new Object[0]);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiCatchSection[] catchSections;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            PsiElement[] tryBlockChildren = tryBlock.getChildren();
            LinkedHashSet<PsiLocalVariable> variables = new LinkedHashSet<PsiLocalVariable>();
            for (PsiLocalVariable variable : TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement)) {
                if (TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext((PsiVariable)variable, (PsiElement)tryBlock)) continue;
                variables.add(variable);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            StringBuilder newTryStatementText = new StringBuilder("try (");
            HashSet<Integer> unwantedChildren = new HashSet<Integer>(2);
            boolean separator = false;
            for (PsiLocalVariable variable : variables) {
                boolean hasInitializer;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    hasInitializer = false;
                } else {
                    PsiType type2 = initializer.getType();
                    boolean bl = hasInitializer = !PsiType.NULL.equals((Object)type2);
                }
                if (separator) {
                    newTryStatementText.append(';');
                }
                newTryStatementText.append(variable.getTypeElement().getText()).append(' ').append(variable.getName()).append('=');
                if (hasInitializer) {
                    newTryStatementText.append(initializer.getText());
                } else {
                    PsiAssignmentExpression assignmentExpression;
                    PsiExpression rhs;
                    int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization(tryBlockChildren, (PsiVariable)variable, false);
                    if (index < 0) {
                        return;
                    }
                    unwantedChildren.add(index);
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)tryBlockChildren[index];
                    if (expressionStatement.getNextSibling() instanceof PsiWhiteSpace) {
                        unwantedChildren.add(index + 1);
                    }
                    if ((rhs = (assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression()).getRExpression()) == null) {
                        return;
                    }
                    newTryStatementText.append(rhs.getText());
                }
                separator = true;
            }
            if (!unwantedChildren.isEmpty()) {
                for (int j = 1; !unwantedChildren.contains(j) && j < tryBlockChildren.length - 1; ++j) {
                    tryStatement.getParent().addBefore(tryBlockChildren[j], (PsiElement)tryStatement);
                    unwantedChildren.add(j);
                }
            }
            newTryStatementText.append(") {");
            int tryBlockStatementsLength = tryBlockChildren.length - 1;
            for (int i2 = 1; i2 < tryBlockStatementsLength; ++i2) {
                PsiElement child = tryBlockChildren[i2];
                if (unwantedChildren.contains(i2)) continue;
                newTryStatementText.append(child.getText());
            }
            newTryStatementText.append('}');
            for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
                newTryStatementText.append(catchSection.getText());
            }
            PsiElement[] finallyChildren = finallyBlock.getChildren();
            boolean appended = false;
            int finallyChildrenLength = finallyChildren.length - 1;
            ArrayList<Object> savedComments = new ArrayList<Object>();
            for (int i3 = 1; i3 < finallyChildrenLength; ++i3) {
                PsiElement child = finallyChildren[i3];
                if (TryFinallyCanBeTryWithResourcesFix.isCloseStatement(child, variables)) continue;
                if (!appended) {
                    if (child instanceof PsiComment) {
                        PsiComment comment = (PsiComment)child;
                        PsiElement psiElement = child.getPrevSibling();
                        if (psiElement instanceof PsiWhiteSpace && savedComments.isEmpty()) {
                            savedComments.add(psiElement);
                        }
                        savedComments.add(comment);
                        PsiElement nextSibling = child.getNextSibling();
                        if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                        savedComments.add(nextSibling);
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace) continue;
                    newTryStatementText.append(" finally {");
                    for (PsiElement psiElement : savedComments) {
                        newTryStatementText.append(psiElement.getText());
                    }
                    newTryStatementText.append(child.getText());
                    appended = true;
                    continue;
                }
                newTryStatementText.append(child.getText());
            }
            if (appended) {
                newTryStatementText.append('}');
            }
            for (PsiLocalVariable variable : variables) {
                variable.delete();
            }
            if (!appended) {
                int savedCommentsSize = savedComments.size();
                PsiElement parent1 = tryStatement.getParent();
                for (int i4 = savedCommentsSize - 1; i4 >= 0; --i4) {
                    PsiElement psiElement = (PsiElement)savedComments.get(i4);
                    parent1.addAfter(psiElement, (PsiElement)tryStatement);
                }
            }
            PsiStatement newTryStatement = factory.createStatementFromText(newTryStatementText.toString(), element);
            tryStatement.replace((PsiElement)newTryStatement);
        }

        private static boolean isCloseStatement(PsiElement element, Set<PsiLocalVariable> variables) {
            if (element instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
                PsiExpression expression2 = expressionStatement.getExpression();
                if (!(expression2 instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"close".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return false;
                }
                PsiLocalVariable variable = (PsiLocalVariable)target;
                return variables.contains(variable);
            }
            if (element instanceof PsiIfStatement) {
                PsiStatement thenBranch;
                PsiIfStatement ifStatement = (PsiIfStatement)element;
                if (ifStatement.getElseBranch() != null) {
                    return false;
                }
                PsiExpression condition2 = ifStatement.getCondition();
                if (!(condition2 instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (!JavaTokenType.NE.equals(tokenType)) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals((Object)rhs.getType())) {
                    if (TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(lhs) == null) {
                        return false;
                    }
                } else if (PsiType.NULL.equals((Object)lhs.getType())) {
                    if (TryFinallyCanBeTryWithResourcesInspection.resolveLocalVariable(rhs) == null) {
                        return false;
                    }
                } else {
                    return false;
                }
                if ((thenBranch = ifStatement.getThenBranch()) instanceof PsiExpressionStatement) {
                    return TryFinallyCanBeTryWithResourcesFix.isCloseStatement((PsiElement)thenBranch, variables);
                }
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    return TryFinallyCanBeTryWithResourcesFix.isCloseStatement((PsiElement)ControlFlowUtils.getOnlyStatementInBlock(codeBlock), variables);
                }
                return false;
            }
            return false;
        }
    }
}

