/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnStatementReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TryWithIdenticalCatchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        return InspectionGadgetsBundle.message("try.with.identical.catches.problem.descriptor", type2.getPresentableText());
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("try.with.identical.catches.display.name", new Object[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file2);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        PsiCatchSection catchSection;
        PsiParameter parameter;
        if (element instanceof PsiCatchSection && (parameter = (catchSection = (PsiCatchSection)element).getParameter()) != null && super.isSuppressedFor((PsiElement)parameter)) {
            return true;
        }
        return super.isSuppressedFor(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryWithIdenticalCatchesVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseCatchSectionsFix((Integer)infos[1], (Integer)infos[2]);
    }

    private static class CollapseCatchSectionsFix
    extends InspectionGadgetsFix {
        private final int myCollapseIntoIndex;
        private final int mySectionIndex;

        public CollapseCatchSectionsFix(int collapseIntoIndex, int sectionIndex) {
            this.myCollapseIntoIndex = collapseIntoIndex;
            this.mySectionIndex = sectionIndex;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("try.with.identical.catches.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiType type2;
            PsiTryStatement tryStatement = (PsiTryStatement)descriptor.getPsiElement().getParent();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (this.myCollapseIntoIndex >= catchSections.length || this.mySectionIndex >= catchSections.length) {
                return;
            }
            PsiCatchSection collapseInto = catchSections[this.myCollapseIntoIndex];
            PsiCatchSection section = catchSections[this.mySectionIndex];
            PsiParameter parameter1 = collapseInto.getParameter();
            PsiParameter parameter2 = section.getParameter();
            if (parameter1 == null || parameter2 == null) {
                return;
            }
            PsiType type1 = parameter1.getType();
            if (TypeConversionUtil.isAssignable((PsiType)type1, (PsiType)(type2 = parameter2.getType()))) {
                section.delete();
                return;
            }
            if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)type1)) {
                collapseInto.delete();
                return;
            }
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            CollapseCatchSectionsFix.collectDisjunctTypes(type1, types);
            CollapseCatchSectionsFix.collectDisjunctTypes(type2, types);
            StringBuilder typeText = new StringBuilder();
            for (PsiType type3 : types) {
                if (typeText.length() > 0) {
                    typeText.append(" | ");
                }
                typeText.append(type3.getCanonicalText());
            }
            PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project2).createTypeElementFromText(typeText.toString(), (PsiElement)tryStatement);
            PsiTypeElement typeElement = parameter1.getTypeElement();
            if (typeElement == null) {
                return;
            }
            typeElement.replace((PsiElement)newTypeElement);
            section.delete();
        }

        private static void collectDisjunctTypes(PsiType type2, List<PsiType> out) {
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                List disjunctions = disjunctionType.getDisjunctions();
                for (PsiType disjunction : disjunctions) {
                    CollapseCatchSectionsFix.collectDisjunctTypes(disjunction, out);
                }
                return;
            }
            Iterator<PsiType> iterator = out.iterator();
            while (iterator.hasNext()) {
                PsiType collectedType = iterator.next();
                if (TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)collectedType)) {
                    iterator.remove();
                    continue;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)collectedType, (PsiType)type2)) continue;
                return;
            }
            out.add(type2);
        }
    }

    private static class TryWithIdenticalCatchesVisitor
    extends BaseInspectionVisitor {
        private TryWithIdenticalCatchesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement statement2) {
            super.visitTryStatement(statement2);
            PsiCatchSection[] catchSections = statement2.getCatchSections();
            if (catchSections.length < 2) {
                return;
            }
            PsiParameter[] parameters2 = statement2.getCatchBlockParameters();
            if (catchSections.length != parameters2.length) {
                return;
            }
            boolean[] duplicates = new boolean[catchSections.length];
            for (int i2 = 0; i2 < catchSections.length - 1; ++i2) {
                PsiParameter parameter;
                PsiCatchSection catchSection = catchSections[i2];
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock == null || (parameter = catchSection.getParameter()) == null) continue;
                InputVariables inputVariables = new InputVariables(Collections.singletonList(parameter), statement2.getProject(), new LocalSearchScope((PsiElement)catchBlock), false);
                DuplicatesFinder finder = new DuplicatesFinder(new PsiElement[]{catchBlock}, inputVariables, null, Collections.emptyList());
                for (int j = i2 + 1; j < catchSections.length; ++j) {
                    PsiElement scope;
                    PsiElement target;
                    PsiElement element;
                    List<PsiElement> parameterValues;
                    ReturnValue returnValue;
                    Match match;
                    PsiCatchSection otherSection;
                    PsiCodeBlock otherCatchBlock;
                    if (duplicates[j] || (otherCatchBlock = (otherSection = catchSections[j]).getCatchBlock()) == null || (match = finder.isDuplicate((PsiElement)otherCatchBlock, true)) == null || (returnValue = match.getReturnValue()) != null && !(returnValue instanceof ReturnStatementReturnValue) || (parameterValues = match.getParameterValues((PsiVariable)parameter)) != null && (parameterValues.size() != 1 || !((element = parameterValues.get(0)) instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)element).resolve()) instanceof PsiParameter) || !otherSection.equals(scope = ((PsiParameter)target).getDeclarationScope())) || (j <= i2 ? !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, j, i2) : !TryWithIdenticalCatchesVisitor.canCollapse(parameters2, i2, j))) continue;
                    PsiJavaToken rParenth = otherSection.getRParenth();
                    if (rParenth != null) {
                        this.registerErrorAtOffset((PsiElement)otherSection, 0, rParenth.getStartOffsetInParent() + 1, parameter.getType(), i2, j);
                    }
                    duplicates[i2] = true;
                    duplicates[j] = true;
                }
            }
        }

        private static boolean canCollapse(PsiParameter[] parameters2, int index1, int index2) {
            if (index2 <= index1) {
                throw new IllegalArgumentException();
            }
            PsiType type2 = parameters2[index2].getType();
            for (int i2 = index1 + 1; i2 < index2; ++i2) {
                PsiType otherType = parameters2[i2].getType();
                if (!TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)otherType)) continue;
                return false;
            }
            return true;
        }
    }
}

