/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiType expectedType;
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression2.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || this.isBoxingNecessary((PsiExpression)expression2, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiType expectedType;
            super.visitMethodCallExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            if (!(boxedExpression.getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            String canonicalText = referenceExpression.getCanonicalText();
            if (PsiTypesUtil.unboxIfPossible((String)canonicalText) == canonicalText || this.isBoxingNecessary((PsiExpression)expression2, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private boolean isBoxingNecessary(PsiExpression boxingExpression, PsiExpression boxedExpression) {
            PsiElement parent = boxingExpression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                boxingExpression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return true;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                return TypeUtils.isTypeParameter(castExpression.getType());
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
                PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
                if (elseExpression2 == null || thenExpression2 == null) {
                    return true;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)thenExpression2, (PsiElement)boxingExpression, (boolean)false)) {
                    PsiType type2 = elseExpression2.getType();
                    return !(type2 instanceof PsiPrimitiveType);
                }
                if (PsiTreeUtil.isAncestor((PsiElement)elseExpression2, (PsiElement)boxingExpression, (boolean)false)) {
                    PsiType type3 = thenExpression2.getType();
                    return !(type3 instanceof PsiPrimitiveType);
                }
                return false;
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                return this.isPossibleObjectComparison(boxingExpression, polyadicExpression);
            }
            return MethodCallUtils.isNecessaryForSurroundingMethodCall(boxingExpression, boxedExpression);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression2, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                if (operand2 == expression2 || operand2.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String replacementText;
            PsiCallExpression expression2 = (PsiCallExpression)descriptor.getPsiElement();
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            Object value2 = ExpressionUtils.computeConstantExpression(unboxedExpression);
            if (value2 != null) {
                if (value2 == Boolean.TRUE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression2, "java.lang.Boolean.TRUE");
                    return;
                }
                if (value2 == Boolean.FALSE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression2, "java.lang.Boolean.FALSE");
                    return;
                }
            }
            if ((replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, (PsiExpression)expression2)) == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, replacementText);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiExpression boxedExpression) {
            PsiType boxedType = boxedExpression.getType();
            if (boxedType == null) {
                return null;
            }
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text = unboxedExpression.getText();
            if (expressionType.equals(unboxedType)) {
                PsiElement parent = boxedExpression.getParent();
                if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(unboxedExpression, (PsiExpression)parent, false)) {
                    return '(' + text + ')';
                }
                return text;
            }
            if (unboxedExpression instanceof PsiLiteralExpression) {
                if (unboxedType.equals(PsiType.LONG) && expressionType.equals(PsiType.INT)) {
                    return text + 'L';
                }
                if (unboxedType.equals(PsiType.FLOAT) && (expressionType.equals(PsiType.INT) || expressionType.equals(PsiType.DOUBLE) && !StringUtil.endsWithIgnoreCase((String)text, (String)"d"))) {
                    return text + 'f';
                }
                if (unboxedType.equals(PsiType.DOUBLE) && expressionType.equals(PsiType.INT)) {
                    return text + 'd';
                }
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return '(' + unboxedType.getCanonicalText() + ")(" + text + ')';
            }
            return '(' + unboxedType.getCanonicalText() + ')' + text;
        }
    }
}

