/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.migration.ForCanBeForeachInspection;
import com.siyeh.ig.migration.WhileCanBeForeachInspectionBase;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class WhileCanBeForeachInspection
extends WhileCanBeForeachInspectionBase {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new WhileCanBeForeachFix();
    }

    private static class WhileCanBeForeachFix
    extends InspectionGadgetsFix {
        private WhileCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement whileElement = descriptor.getPsiElement();
            PsiWhileStatement whileStatement = (PsiWhileStatement)whileElement.getParent();
            WhileCanBeForeachFix.replaceWhileWithForEach(whileStatement);
        }

        private static void replaceWhileWithForEach(@NotNull PsiWhileStatement whileStatement) {
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiStatement body2 = whileStatement.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement initialization = WhileCanBeForeachInspectionBase.getPreviousStatement((PsiElement)whileStatement);
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            if (declaration2 == null) {
                return;
            }
            PsiElement declaredElement = declaration2.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable iterator = (PsiLocalVariable)declaredElement;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = ExpressionUtils.getQualifierOrThis(methodExpression);
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return;
            }
            PsiType contentType = ForCanBeForeachInspection.getContentType(collectionType, "java.lang.Iterable");
            if (contentType == null) {
                return;
            }
            PsiType iteratorType = iterator.getType();
            PsiType iteratorContentType = ForCanBeForeachInspection.getContentType(iteratorType, "java.util.Iterator");
            if (iteratorContentType == null) {
                return;
            }
            Project project2 = whileStatement.getProject();
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, (PsiVariable)iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElements[0];
                contentVariableName = localVariable.getName();
                statementToSkip = declarationStatement;
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)collection;
                    String collectionName = referenceElement.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, null);
                }
                statementToSkip = null;
            }
            StringBuilder out = new StringBuilder();
            out.append("for(");
            if (CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_PARAMETERS) {
                out.append("final ");
            }
            out.append(iteratorContentType.getCanonicalText()).append(' ').append(contentVariableName).append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                out.append("(java.lang.Iterable<").append(iteratorContentType.getCanonicalText()).append(">)");
            }
            out.append(collection.getText());
            out.append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body2, contentVariableName, (PsiVariable)iterator, contentType, (PsiElement)statementToSkip, out);
            Query query = ReferencesSearch.search((PsiElement)iterator);
            boolean deleteIterator = true;
            for (PsiReference usage : query) {
                PsiElement element = usage.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)element, (boolean)true)) continue;
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
                if (assignment == null) {
                    deleteIterator = false;
                    break;
                }
                PsiExpression expression2 = assignment.getRExpression();
                initializer.delete();
                iterator.setInitializer(expression2);
                PsiElement statement2 = assignment.getParent();
                PsiElement lastChild = statement2.getLastChild();
                if (lastChild instanceof PsiComment) {
                    iterator.add(lastChild);
                }
                statement2.replace((PsiElement)iterator);
                break;
            }
            if (deleteIterator) {
                iterator.delete();
            }
            String result2 = out.toString();
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)whileStatement, result2);
        }
    }
}

