/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.migration.ForCanBeForeachInspectionBase;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspectionBase
extends BaseInspection {
    @Nullable
    static PsiStatement getPreviousStatement(PsiElement context) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)context, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (!(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "WhileLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("while.can.be.foreach.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasNextCalled;
        private final PsiVariable iterator;

        private IteratorHasNextVisitor(@NotNull PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.hasNextCalled = true;
            }
        }

        boolean isHasNextCalled() {
            return this.hasNextCalled;
        }
    }

    private static class NumberCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext;
        private final PsiVariable iterator;

        private NumberCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            super.visitWhileStatement(whileStatement);
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiStatement initialization = WhileCanBeForeachInspectionBase.getPreviousStatement((PsiElement)whileStatement);
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator", "java.util.ListIterator")) {
                return false;
            }
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            PsiExpressionList argumentList = initialCall.getArgumentList();
            PsiExpression[] argument = argumentList.getExpressions();
            if (argument.length != 0) {
                return false;
            }
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName) && !"listIterator".equals(initialCallName)) {
                return false;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(initialMethodExpression);
            if (qualifier instanceof PsiSuperExpression) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.lang.Iterable")) {
                return false;
            }
            PsiExpression condition2 = whileStatement.getCondition();
            if (!ForCanBeForeachInspectionBase.isHasNext(condition2, variable)) {
                return false;
            }
            PsiStatement body2 = whileStatement.getBody();
            if (body2 == null) {
                return false;
            }
            if (WhileCanBeForeachVisitor.calculateCallsToIteratorNext(variable, (PsiElement)body2) != 1) {
                return false;
            }
            if (ForCanBeForeachInspectionBase.isIteratorMethodCalled(variable, body2)) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorHasNextCalled(variable, (PsiElement)body2)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, (PsiElement)body2)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)body2)) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed(variable, nextSibling)) continue;
                return false;
            }
            return true;
        }

        private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiElement context) {
            NumberCallsToIteratorNextVisitor visitor = new NumberCallsToIteratorNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.getNumCallsToIteratorNext();
        }

        private static boolean isIteratorHasNextCalled(PsiVariable iterator, PsiElement context) {
            IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iterator);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isHasNextCalled();
        }
    }
}

