/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.modularization;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassOnlyUsedInOneModuleInspection
extends BaseGlobalInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.only.used.in.one.module.display.name", new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        RefModule otherModule = null;
        for (RefClass refClass2 : dependencies) {
            RefModule module2 = refClass2.getModule();
            if (refClass.getModule() == module2) {
                return null;
            }
            if (otherModule == module2) continue;
            if (otherModule == null) {
                otherModule = module2;
                continue;
            }
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            RefModule module3 = dependent.getModule();
            if (refClass.getModule() == module3) {
                return null;
            }
            if (otherModule == module3) continue;
            if (otherModule == null) {
                otherModule = module3;
                continue;
            }
            return null;
        }
        if (otherModule == null) {
            return null;
        }
        PsiClass psiClass = refClass.getElement();
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        String moduleName = otherModule.getName();
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("class.only.used.in.one.module.problem.descriptor", moduleName), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }
}

