/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;
    public boolean onlyCheckImmutables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.naming.convention.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("constant.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (field instanceof PsiEnumConstant) {
                return;
            }
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
                return;
            }
            String name = field.getName();
            if (name == null) {
                return;
            }
            PsiType type2 = field.getType();
            if (ConstantNamingConventionInspectionBase.this.onlyCheckImmutables && !ClassUtils.isImmutable(type2)) {
                return;
            }
            if (ConstantNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerFieldError(field, name);
        }
    }
}

