/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DollarSignInNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("dollar.sign.in.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("dollar.sign.in.name.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DollarSignInNameVisitor();
    }

    private static class DollarSignInNameVisitor
    extends BaseInspectionVisitor {
        private DollarSignInNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            super.visitMethod(method2);
            String name = method2.getName();
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerMethodError(method2, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

