/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.name.same.as.class.name.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.name.same.as.class.name.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsClassNameVisitor();
    }

    private static class MethodNameSameAsClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsClassNameVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2.isConstructor()) {
                return;
            }
            String methodName = method2.getName();
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getName();
            if (className == null) {
                return;
            }
            if (!methodName.equals(className)) {
                return;
            }
            this.registerMethodError(method2, this.isOnTheFly());
        }
    }
}

