/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MisspelledMethodNameInspectionBase
extends BaseInspection {
    public boolean ignoreIfMethodIsOverride = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.names.differ.only.by.case.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.names.differ.only.by.case.problem.descriptor", infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNamesDifferOnlyByCaseVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class MethodNamesDifferOnlyByCaseVisitor
    extends BaseInspectionVisitor {
        private MethodNamesDifferOnlyByCaseVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiMethod[] methods = aClass.getAllMethods();
            THashMap methodNames = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            THashMap errorNames = new THashMap();
            for (PsiMethod method2 : methods) {
                PsiIdentifier identifier;
                ProgressManager.checkCanceled();
                if (method2.isConstructor() || MisspelledMethodNameInspectionBase.this.ignoreIfMethodIsOverride && MethodUtils.hasSuper(method2)) continue;
                String name = method2.getName();
                PsiMethod existing = (PsiMethod)methodNames.get(name);
                if (existing == null) {
                    methodNames.put(name, method2);
                    continue;
                }
                PsiClass methodClass = method2.getContainingClass();
                PsiClass existingMethodClass = existing.getContainingClass();
                String existingName = existing.getName();
                if (name.equals(existingName)) continue;
                if (existingMethodClass == aClass && (identifier = existing.getNameIdentifier()) != null) {
                    errorNames.put(identifier, name);
                }
                if (methodClass != aClass || (identifier = method2.getNameIdentifier()) == null) continue;
                errorNames.put(identifier, existingName);
            }
            for (Map.Entry entry : errorNames.entrySet()) {
                PsiIdentifier identifier = (PsiIdentifier)entry.getKey();
                String otherName = (String)entry.getValue();
                this.registerError((PsiElement)identifier, otherName);
            }
        }
    }
}

