/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverloadedMethodsWithSameNumberOfParametersInspection
extends BaseInspection {
    public boolean ignoreInconvertibleTypes = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overloaded.methods.with.same.number.parameters.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInconvertibleTypes");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedMethodsWithSameNumberOfParametersVisitor();
    }

    private class OverloadedMethodsWithSameNumberOfParametersVisitor
    extends BaseInspectionVisitor {
        private OverloadedMethodsWithSameNumberOfParametersVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiMethod[] sameNameMethods;
            if (method2.isConstructor()) {
                return;
            }
            if (method2.getNameIdentifier() == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method2)) {
                return;
            }
            String methodName = method2.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
                PsiParameterList otherParameterList;
                if (method2.equals(sameNameMethod) || parameterCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
                if (OverloadedMethodsWithSameNumberOfParametersInspection.this.ignoreInconvertibleTypes && !this.areParameterTypesConvertible(parameterList, otherParameterList)) {
                    return;
                }
                this.registerMethodError(method2, new Object[0]);
                return;
            }
        }

        private boolean areParameterTypesConvertible(PsiParameterList parameterList, PsiParameterList otherParameterList) {
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter[] otherParameters = otherParameterList.getParameters();
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType otherType;
                PsiType type2 = parameters2[i2].getType();
                if (type2.isAssignableFrom(otherType = otherParameters[i2].getType()) || otherType.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
    }
}

