/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedVarargsMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overloaded.vararg.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod element = (PsiMethod)infos[0];
        if (element.isConstructor()) {
            return InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            PsiMethod[] sameNameMethods;
            if (!method2.isVarArgs()) {
                return;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method2.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, true)) {
                PsiSubstitutor substitutor;
                PsiClass superClass = sameNameMethod.getContainingClass();
                PsiSubstitutor psiSubstitutor = substitutor = superClass != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
                if (MethodSignatureUtil.areSignaturesEqual((MethodSignature)sameNameMethod.getSignature(substitutor), (MethodSignature)method2.getSignature(PsiSubstitutor.EMPTY))) continue;
                this.registerMethodError(method2, method2);
                return;
            }
        }
    }
}

