/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class BigDecimalEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("big.decimal.equals.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("big.decimal.equals.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new BigDecimalEqualsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalEqualsVisitor();
    }

    private static class BigDecimalEqualsVisitor
    extends BaseInspectionVisitor {
        private BigDecimalEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isEqualsCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression arg = arguments[0];
            if (!ExpressionUtils.hasType(arg, "java.math.BigDecimal")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!ExpressionUtils.hasType(qualifier, "java.math.BigDecimal")) {
                return;
            }
            PsiElement context = expression2.getParent();
            if (context instanceof PsiExpressionStatement) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private static class BigDecimalEqualsFix
    extends InspectionGadgetsFix {
        private BigDecimalEqualsFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("big.decimal.equals.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name.getParent();
            assert (expression2 != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2.getParent();
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            String argText = args[0].getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)call, qualifierText + ".compareTo(" + argText + ")==0");
        }
    }
}

