/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CastThatLosesPrecisionInspection
extends BaseInspection {
    public boolean ignoreIntegerCharCasts = false;

    @NotNull
    public String getID() {
        return "NumericCastThatLosesPrecision";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cast.that.loses.precision.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        return InspectionGadgetsBundle.message("cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), (InspectionProfileEntry)this, "ignoreIntegerCharCasts");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            Number number;
            PsiMethod method2;
            PsiType castType = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType operandType = operand2.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType) || !TypeUtils.isNarrowingConversion(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiType.INT.equals((Object)operandType) && PsiType.CHAR.equals((Object)castType)) {
                return;
            }
            if (PsiType.LONG.equals((Object)operandType) && PsiType.INT.equals((Object)castType) && MethodUtils.isHashCode(method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            Object result2 = ExpressionUtils.computeConstantExpression(operand2);
            if (result2 instanceof Character) {
                result2 = (int)((Character)result2).charValue();
            }
            if (result2 instanceof Number && this.valueIsContainableInType(number = (Number)result2, castType)) {
                return;
            }
            PsiTypeElement castTypeElement = expression2.getCastType();
            if (castTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType);
        }

        private boolean valueIsContainableInType(Number value2, PsiType type2) {
            long longValue = value2.longValue();
            double doubleValue = value2.doubleValue();
            if (PsiType.BYTE.equals((Object)type2)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiType.CHAR.equals((Object)type2)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiType.SHORT.equals((Object)type2)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiType.INT.equals((Object)type2)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiType.LONG.equals((Object)type2)) {
                return longValue >= Long.MIN_VALUE && longValue <= Long.MAX_VALUE && doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiType.FLOAT.equals((Object)type2)) {
                return doubleValue == (double)value2.floatValue();
            }
            return PsiType.DOUBLE.equals((Object)type2);
        }
    }
}

