/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantMathCallInspection
extends BaseInspection {
    @NonNls
    static final Set<String> constantMathCall = new HashSet<String>(23);

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.math.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.math.call.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeStrictFix();
    }

    @Nullable
    @NonNls
    static String createValueString(@NonNls String name, double value2) {
        if ("abs".equals(name)) {
            return Double.toString(Math.abs(value2));
        }
        if ("floor".equals(name)) {
            return Double.toString(Math.floor(value2));
        }
        if ("ceil".equals(name)) {
            return Double.toString(Math.ceil(value2));
        }
        if ("toDegrees".equals(name)) {
            return Double.toString(Math.toDegrees(value2));
        }
        if ("toRadians".equals(name)) {
            return Double.toString(Math.toRadians(value2));
        }
        if ("sqrt".equals(name)) {
            return Double.toString(Math.sqrt(value2));
        }
        if ("cbrt".equals(name)) {
            return Double.toString(Math.pow(value2, 0.3333333333333333));
        }
        if ("round".equals(name)) {
            return Long.toString(Math.round(value2));
        }
        if ("rint".equals(name)) {
            return Double.toString(Math.rint(value2));
        }
        if ("log".equals(name)) {
            if (value2 == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("log10".equals(name)) {
            if (value2 == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("log1p".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("exp".equals(name)) {
            if (value2 == 0.0) {
                return "1.0";
            }
            if (value2 == 1.0) {
                return "Math.E";
            }
            return null;
        }
        if ("expm1".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("cos".equals(name) || "cosh".equals(name)) {
            if (value2 == 0.0) {
                return "1.0";
            }
            return null;
        }
        if ("acos".equals(name)) {
            if (value2 == 1.0) {
                return "0.0";
            }
            if (value2 == 0.0) {
                return "(Math.PI/2.0)";
            }
            return null;
        }
        if ("acosh".equals(name)) {
            if (value2 == 1.0) {
                return "0.0";
            }
            return null;
        }
        if ("sin".equals(name) || "sinh".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("asin".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            if (value2 == 1.0) {
                return "(Math.PI/2.0)";
            }
            return null;
        }
        if ("asinh".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("tan".equals(name) || "tanh".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        if ("atan".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            if (value2 == 1.0) {
                return "(Math.PI/4.0)";
            }
            return null;
        }
        if ("atanh".equals(name)) {
            if (value2 == 0.0) {
                return "0.0";
            }
            return null;
        }
        return null;
    }

    @Nullable
    @NonNls
    static String createValueString(@NonNls String name, long value2) {
        if ("abs".equals(name)) {
            return Long.toString(Math.abs(value2));
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantMathCallVisitor();
    }

    static {
        constantMathCall.add("abs");
        constantMathCall.add("acos");
        constantMathCall.add("asin");
        constantMathCall.add("atan");
        constantMathCall.add("cbrt");
        constantMathCall.add("ceil");
        constantMathCall.add("cos");
        constantMathCall.add("cosh");
        constantMathCall.add("exp");
        constantMathCall.add("expm1");
        constantMathCall.add("floor");
        constantMathCall.add("log");
        constantMathCall.add("log10");
        constantMathCall.add("log1p");
        constantMathCall.add("rint");
        constantMathCall.add("round");
        constantMathCall.add("sin");
        constantMathCall.add("sinh");
        constantMathCall.add("sqrt");
        constantMathCall.add("tan");
        constantMathCall.add("tanh");
        constantMathCall.add("toDegrees");
        constantMathCall.add("toRadians");
    }

    private static class ConstantMathCallVisitor
    extends BaseInspectionVisitor {
        private ConstantMathCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!constantMathCall.contains(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            Object argumentValue = ConstantExpressionUtil.computeCastTo((PsiExpression)argument, (PsiType)PsiType.DOUBLE);
            if (!(argumentValue instanceof Double)) {
                return;
            }
            double doubleValue = (Double)argumentValue;
            String valueString = ConstantMathCallInspection.createValueString(methodName, doubleValue);
            if (valueString == null) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass referencedClass = method2.getContainingClass();
            if (referencedClass == null) {
                return;
            }
            String className = referencedClass.getQualifiedName();
            if (!"java.lang.Math".equals(className) && !"java.lang.StrictMath".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private static class MakeStrictFix
    extends InspectionGadgetsFix {
        private MakeStrictFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String newExpression;
            PsiIdentifier nameIdentifier = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression reference = (PsiReferenceExpression)nameIdentifier.getParent();
            assert (reference != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)reference.getParent();
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            String methodName = reference.getReferenceName();
            PsiExpression argument = arguments[0];
            PsiMethod method2 = call.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiParameterList parameterList = method2.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length != 1) {
                return;
            }
            PsiType type2 = parameters2[0].getType();
            Object argumentValue = ConstantExpressionUtil.computeCastTo((PsiExpression)argument, (PsiType)type2);
            if (argumentValue instanceof Float || argumentValue instanceof Double) {
                Number number = (Number)argumentValue;
                newExpression = ConstantMathCallInspection.createValueString(methodName, number.doubleValue());
            } else {
                Number number = (Number)argumentValue;
                newExpression = ConstantMathCallInspection.createValueString(methodName, number.longValue());
            }
            if (newExpression == null) {
                return;
            }
            if (PsiType.LONG.equals((Object)type2)) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpression + 'L');
            } else {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpression);
            }
        }
    }
}

