/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class DivideByZeroInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "divzero";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("divide.by.zero.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("divide.by.zero.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.DIV.equals(tokenType) && !JavaTokenType.PERC.equals(tokenType)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i2 = 1; i2 < operands2.length; ++i2) {
                PsiExpression operand2 = operands2[i2];
                if (!DivisionByZeroVisitor.isZero(operand2)) continue;
                this.registerError((PsiElement)operand2, new Object[0]);
                return;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = expression2.getRExpression();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIVEQ) && !tokenType.equals(JavaTokenType.PERCEQ) || !DivisionByZeroVisitor.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isZero(PsiExpression expression2) {
            Object value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.DOUBLE);
            if (!(value2 instanceof Double)) {
                return false;
            }
            double constantValue = (Double)value2;
            return constantValue == 0.0 || constantValue == -0.0;
        }
    }
}

