/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitNumericConversionInspection
extends BaseInspection {
    public boolean ignoreWideningConversions = false;
    public boolean ignoreCharConversions = false;
    public boolean ignoreConstantConversions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("implicit.numeric.conversion.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.widening.conversion.option", new Object[0]), "ignoreWideningConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.char.conversion.option", new Object[0]), "ignoreCharConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.constant.conversion.option", new Object[0]), "ignoreConstantConversions");
        return optionsPanel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[1];
        PsiType expectedType = (PsiType)infos[2];
        return InspectionGadgetsBundle.message("implicit.numeric.conversion.problem.descriptor", type2.getPresentableText(), expectedType.getPresentableText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitNumericConversionVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ImplicitNumericConversionFix((PsiExpression)infos[0], (PsiType)infos[2]);
    }

    private class ImplicitNumericConversionVisitor
    extends BaseInspectionVisitor {
        private ImplicitNumericConversionVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            super.visitPostfixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            PsiType expressionType;
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreConstantConversions) {
                PsiExpression rootExpression = expression2;
                while (rootExpression instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)rootExpression;
                    rootExpression = parenthesizedExpression.getExpression();
                }
                if (rootExpression instanceof PsiLiteralExpression || PsiUtil.isConstantExpression((PsiExpression)rootExpression)) {
                    return;
                }
            }
            if ((expressionType = expression2.getType()) == null || !ClassUtils.isPrimitiveNumericType(expressionType)) {
                return;
            }
            if (PsiType.CHAR.equals((Object)expressionType) && (ImplicitNumericConversionInspection.this.ignoreCharConversions || this.isArgumentOfStringIndexOf(parent))) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (!ClassUtils.isPrimitiveNumericType(expectedType)) {
                return;
            }
            if (expressionType.equals(expectedType)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreWideningConversions && !TypeUtils.isNarrowingConversion(expressionType, expectedType)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreCharConversions && PsiType.CHAR.equals((Object)expectedType)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, expressionType, expectedType);
        }

        private boolean isArgumentOfStringIndexOf(PsiElement parent) {
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"indexOf".equals(methodName) && !"lastIndexOf".equals(methodName)) {
                return false;
            }
            PsiMethod method2 = methodCallExpression.resolveMethod();
            if (method2 == null) {
                return false;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }
    }

    private static class ImplicitNumericConversionFix
    extends InspectionGadgetsFix {
        private final String m_name;

        ImplicitNumericConversionFix(PsiExpression expression2, PsiType expectedType) {
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression2, expectedType);
            this.m_name = convertedExpression != null ? InspectionGadgetsBundle.message("implicit.numeric.conversion.convert.quickfix", convertedExpression) : InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (expectedType == null) {
                return;
            }
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression2, expectedType);
            if (convertedExpression != null) {
                PsiReplacementUtil.replaceExpression(expression2, convertedExpression);
            } else {
                PsiAssignmentExpression assignmentExpression;
                PsiJavaToken sign;
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiAssignmentExpression && !JavaTokenType.EQ.equals((sign = (assignmentExpression = (PsiAssignmentExpression)parent).getOperationSign()).getTokenType())) {
                    String lhsText = assignmentExpression.getLExpression().getText();
                    String newExpressionText = lhsText + "=(" + expectedType.getCanonicalText() + ")(" + lhsText + sign.getText().charAt(0) + expression2.getText() + ')';
                    PsiReplacementUtil.replaceExpression((PsiExpression)assignmentExpression, newExpressionText);
                    return;
                }
                String castExpression = ParenthesesUtils.getPrecedence(expression2) <= 4 ? '(' + expectedType.getCanonicalText() + ')' + expression2.getText() : '(' + expectedType.getCanonicalText() + ")(" + expression2.getText() + ')';
                PsiReplacementUtil.replaceExpression(expression2, castExpression);
            }
        }

        @Nullable
        @NonNls
        private static String convertExpression(PsiExpression expression2, PsiType expectedType) {
            if (!(expression2 instanceof PsiLiteralExpression) && !ImplicitNumericConversionFix.isNegatedLiteral(expression2)) {
                return null;
            }
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                return null;
            }
            String text = expression2.getText();
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.LONG)) {
                return text + 'L';
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.FLOAT)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text + ".0F";
            }
            if (expressionType.equals(PsiType.INT) && expectedType.equals(PsiType.DOUBLE)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text + ".0";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.FLOAT)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text.substring(0, text.length() - 1) + ".0F";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType.equals(PsiType.DOUBLE)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text)) {
                    return null;
                }
                return text.substring(0, text.length() - 1) + ".0";
            }
            if (expressionType.equals(PsiType.DOUBLE) && expectedType.equals(PsiType.FLOAT)) {
                int length = text.length();
                if (text.charAt(length - 1) == 'd' || text.charAt(length - 1) == 'D') {
                    return text.substring(0, length - 1) + 'F';
                }
                return text + 'F';
            }
            if (expressionType.equals(PsiType.FLOAT) && expectedType.equals(PsiType.DOUBLE)) {
                int length = text.length();
                return text.substring(0, length - 1);
            }
            return null;
        }

        private static boolean isDecimalLiteral(String text) {
            return text.length() > 0 && text.charAt(0) != '0';
        }

        private static boolean isNegatedLiteral(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPrefixExpression)) {
                return false;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(tokenType)) {
                return false;
            }
            PsiExpression operand2 = prefixExpression.getOperand();
            return operand2 instanceof PsiLiteralExpression;
        }

        private static boolean isIntegral(@Nullable PsiType expressionType) {
            return PsiType.INT.equals((Object)expressionType) || PsiType.LONG.equals((Object)expressionType);
        }

        private static boolean isFloatingPoint(@Nullable PsiType expressionType) {
            return PsiType.FLOAT.equals((Object)expressionType) || PsiType.DOUBLE.equals((Object)expressionType);
        }
    }
}

