/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IntLiteralMayBeLongLiteralInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("int.literal.may.be.long.literal.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = IntLiteralMayBeLongLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return InspectionGadgetsBundle.message("int.literal.may.be.long.literal.problem.descriptor", replacementText);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos[0];
        StringBuilder replacementText = IntLiteralMayBeLongLiteralInspection.buildReplacementText((PsiExpression)typeCastExpression, new StringBuilder());
        return new IntLiteralMayBeLongLiteralFix(replacementText.toString());
    }

    private static StringBuilder buildReplacementText(PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiLiteralExpression) {
            out.append(expression2.getText());
            out.append('L');
        } else {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                out.append(sign.getText());
                return IntLiteralMayBeLongLiteralInspection.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                out.append('(');
                IntLiteralMayBeLongLiteralInspection.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                PsiExpression operand2 = typeCastExpression.getOperand();
                IntLiteralMayBeLongLiteralInspection.buildReplacementText(operand2, out);
            } else assert (false);
        }
        return out;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntLiteralMayBeLongLiteralVisitor();
    }

    private static class IntLiteralMayBeLongLiteralVisitor
    extends BaseInspectionVisitor {
        private IntLiteralMayBeLongLiteralVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!PsiType.INT.equals((Object)type2)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            while (parent instanceof PsiPrefixExpression || parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (!PsiType.LONG.equals((Object)castType)) {
                return;
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }
    }

    private static class IntLiteralMayBeLongLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        public IntLiteralMayBeLongLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("int.literal.may.be.long.literal.quickfix", this.replacementString);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with long literal";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }
    }
}

