/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_typesToCheck = new HashSet<String>(4);
    public boolean ignoreNonOverflowingCompileTimeConstants = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        IElementType tokenType = (IElementType)infos[0];
        if (JavaTokenType.ASTERISK.equals(tokenType)) {
            return InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("integer.shift.implicit.cast.to.long.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonOverflowingCompileTimeConstants");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    static {
        s_typesToCheck.add("int");
        s_typesToCheck.add("short");
        s_typesToCheck.add("byte");
        s_typesToCheck.add("char");
        s_typesToCheck.add("java.lang.Integer");
        s_typesToCheck.add("java.lang.Short");
        s_typesToCheck.add("java.lang.Byte");
        s_typesToCheck.add("java.lang.Character");
    }

    private class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!this.isNonLongInteger(type2)) {
                return;
            }
            if (expression2.getOperands().length < 2 || expression2.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            PsiExpression context = this.getContainingExpression((PsiExpression)expression2);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.LONG)) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.this.ignoreNonOverflowingCompileTimeConstants) {
                try {
                    if (ExpressionUtils.computeConstantExpression((PsiExpression)expression2, true) != null) {
                        return;
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
            }
            this.registerError((PsiElement)expression2, tokenType);
        }

        private PsiExpression getContainingExpression(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return this.getContainingExpression((PsiExpression)parent);
            }
            return expression2;
        }

        private boolean isNonLongInteger(PsiType type2) {
            if (type2 == null) {
                return false;
            }
            String text = type2.getCanonicalText();
            return text != null && s_typesToCheck.contains(text);
        }
    }
}

