/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class OctalLiteralInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "OctalInteger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("octal.literal.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("octal.literal.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalLiteralVisitor();
    }

    private static class OctalLiteralVisitor
    extends BaseInspectionVisitor {
        private OctalLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            super.visitLiteralExpression(literal);
            PsiType type2 = literal.getType();
            if (type2 == null) {
                return;
            }
            if (!type2.equals(PsiType.INT) && !type2.equals(PsiType.LONG)) {
                return;
            }
            String text = literal.getText();
            if (text.length() == 1) {
                return;
            }
            if (text.charAt(0) != '0') {
                return;
            }
            char c1 = text.charAt(1);
            if (c1 != '_' && (c1 < '0' || c1 > '7')) {
                return;
            }
            if (literal.getValue() == null) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }
    }
}

