/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexArithmeticExpressionInspectionBase
extends BaseInspection {
    protected static final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);
    private static final int TERM_LIMIT = 6;
    public int m_limit = 6;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyComplexArithmeticExpressionVisitor();
    }

    private class OverlyComplexArithmeticExpressionVisitor
    extends BaseInspectionVisitor {
        private OverlyComplexArithmeticExpressionVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression((PsiExpression)expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            if (this.isParentArithmetic(expression2)) {
                return;
            }
            if (!this.isArithmetic(expression2)) {
                return;
            }
            int numTerms = this.countTerms(expression2);
            if (numTerms <= OverlyComplexArithmeticExpressionInspectionBase.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private int countTerms(PsiExpression expression2) {
            if (!this.isArithmetic(expression2)) {
                return 1;
            }
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiExpression operand2 = prefixExpression.getOperand();
                return this.countTerms(operand2);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            return parent instanceof PsiExpression && this.isArithmetic((PsiExpression)parent);
        }

        private boolean isArithmetic(PsiExpression expression2) {
            if (expression2 instanceof PsiBinaryExpression) {
                PsiType type2 = expression2.getType();
                if (TypeUtils.isJavaLangString(type2)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                return arithmeticTokens.contains(binaryExpression.getOperationTokenType());
            }
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                return arithmeticTokens.contains(prefixExpression.getOperationTokenType());
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.isArithmetic(contents);
            }
            return false;
        }
    }
}

