/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroFix
extends InspectionGadgetsFix {
    RemoveLeadingZeroFix() {
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("remove.leading.zero.to.make.decimal.quickfix", new Object[0]);
    }

    @Override
    protected void doFix(Project project2, ProblemDescriptor descriptor) {
        int index;
        PsiLiteralExpression literal = (PsiLiteralExpression)descriptor.getPsiElement();
        String text = literal.getText();
        int max = text.length() - (PsiType.LONG.equals((Object)literal.getType()) ? 2 : 1);
        if (max < 1) {
            return;
        }
        for (index = 0; index < max && (text.charAt(index) == '0' || text.charAt(index) == '_'); ++index) {
        }
        String textWithoutLeadingZeros = text.substring(index);
        PsiReplacementUtil.replaceExpression((PsiExpression)literal, textWithoutLeadingZeros);
    }
}

