/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnaryPlusInspection
extends BaseInspection {
    public boolean onlyReportInsideBinaryExpression = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unary.plus.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unary.plus.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only report in confusing binary or unary expression context", (InspectionProfileEntry)this, "onlyReportInsideBinaryExpression");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (!this.onlyReportInsideBinaryExpression) {
            node.addContent(new Element("option").setAttribute("name", "onlyReportInsideBinaryExpression").setAttribute("value", "false"));
        }
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnaryPlusFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnaryPlusVisitor();
    }

    private class UnaryPlusVisitor
    extends BaseInspectionVisitor {
        private UnaryPlusVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression prefixExpression) {
            super.visitPrefixExpression(prefixExpression);
            PsiJavaToken token = prefixExpression.getOperationSign();
            IElementType tokenType = token.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            PsiExpression operand2 = prefixExpression.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType type2 = operand2.getType();
            if (type2 == null) {
                return;
            }
            if (UnaryPlusInspection.this.onlyReportInsideBinaryExpression) {
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)prefixExpression);
                if (!(operand2 instanceof PsiParenthesizedExpression || operand2 instanceof PsiPrefixExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiPrefixExpression)) {
                    return;
                }
            } else if (TypeUtils.unaryNumericPromotion(type2) != type2 && MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)prefixExpression, operand2)) {
                return;
            }
            this.registerError((PsiElement)token, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }
    }

    private static class UnaryPlusFix
    extends InspectionGadgetsFix {
        private UnaryPlusFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unary.plus.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            PsiExpression operand2 = prefixExpression.getOperand();
            if (operand2 == null) {
                return;
            }
            prefixExpression.replace((PsiElement)operand2);
        }
    }
}

