/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryExplicitNumericCastInspection
extends BaseInspection {
    private static final Set<IElementType> binaryPromotionOperators = new THashSet();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        return InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.problem.descriptor", expression2.getText());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryExplicitNumericCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryExplicitNumericCastVisitor();
    }

    public static boolean isPrimitiveNumericCastNecessary(PsiTypeCastExpression expression2) {
        PsiType castType = expression2.getType();
        if (castType == null) {
            return true;
        }
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            return true;
        }
        PsiType operandType = operand2.getType();
        if (operandType == null) {
            return true;
        }
        PsiElement parent = expression2.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (binaryPromotionOperators.contains(tokenType)) {
                if (TypeUtils.isNarrowingConversion(operandType, castType)) {
                    return true;
                }
                if (PsiType.INT.equals((Object)castType)) {
                    if (PsiType.CHAR.equals((Object)operandType) && TypeUtils.getStringType((PsiElement)polyadicExpression).equals((Object)polyadicExpression.getType())) {
                        return true;
                    }
                    return PsiType.LONG.equals((Object)operandType) || PsiType.FLOAT.equals((Object)operandType) || PsiType.DOUBLE.equals((Object)operandType);
                }
                if (PsiType.LONG.equals((Object)castType) || PsiType.FLOAT.equals((Object)castType) || PsiType.DOUBLE.equals((Object)castType)) {
                    PsiExpression[] operands2;
                    for (PsiExpression operand1 : operands2 = polyadicExpression.getOperands()) {
                        PsiType type2;
                        if (PsiTreeUtil.isAncestor((PsiElement)operand1, (PsiElement)expression2, (boolean)false) || !castType.equals(type2 = operand1.getType())) continue;
                        return false;
                    }
                }
            } else if (JavaTokenType.GTGT.equals(tokenType) || JavaTokenType.GTGTGT.equals(tokenType) || JavaTokenType.LTLT.equals(tokenType)) {
                PsiExpression firstOperand = polyadicExpression.getOperands()[0];
                if (!PsiTreeUtil.isAncestor((PsiElement)firstOperand, (PsiElement)expression2, (boolean)false)) {
                    return false;
                }
                return PsiType.LONG.equals((Object)castType) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand2, (PsiType)PsiType.INT);
            }
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiType lhsType = assignmentExpression.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand2, lhsType);
        }
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType lhsType = variable.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand2, lhsType);
        }
        if (MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)expression2, operand2)) {
            return true;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false);
        return !castType.equals(expectedType) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand2, castType);
    }

    static boolean isLegalWideningConversion(PsiExpression expression2, PsiType requiredType) {
        PsiType operandType = expression2.getType();
        return PsiType.DOUBLE.equals((Object)requiredType) ? PsiType.FLOAT.equals((Object)operandType) || PsiType.LONG.equals((Object)operandType) || PsiType.INT.equals((Object)operandType) || PsiType.CHAR.equals((Object)operandType) || PsiType.SHORT.equals((Object)operandType) || PsiType.BYTE.equals((Object)operandType) : (PsiType.FLOAT.equals((Object)requiredType) ? PsiType.LONG.equals((Object)operandType) || PsiType.INT.equals((Object)operandType) || PsiType.CHAR.equals((Object)operandType) || PsiType.SHORT.equals((Object)operandType) || PsiType.BYTE.equals((Object)operandType) : (PsiType.LONG.equals((Object)requiredType) ? PsiType.INT.equals((Object)operandType) || PsiType.CHAR.equals((Object)operandType) || PsiType.SHORT.equals((Object)operandType) || PsiType.BYTE.equals((Object)operandType) : PsiType.INT.equals((Object)requiredType) && (PsiType.CHAR.equals((Object)operandType) || PsiType.SHORT.equals((Object)operandType) || PsiType.BYTE.equals((Object)operandType))));
    }

    static boolean isLegalAssignmentConversion(PsiExpression expression2, PsiType assignmentType) {
        if (UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(expression2, assignmentType)) {
            return true;
        }
        if (PsiType.SHORT.equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (PsiType.CHAR.equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, 0, 65535);
        }
        if (PsiType.BYTE.equals((Object)assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, -128, 127);
        }
        return false;
    }

    private static boolean canValueBeContained(PsiExpression expression2, int lowerBound, int upperBound) {
        PsiType expressionType = expression2.getType();
        if (!PsiType.INT.equals((Object)expressionType)) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(expression2);
        if (!(constant instanceof Integer)) {
            return false;
        }
        int i2 = (Integer)constant;
        return i2 >= lowerBound && i2 <= upperBound;
    }

    static {
        binaryPromotionOperators.add(JavaTokenType.ASTERISK);
        binaryPromotionOperators.add(JavaTokenType.DIV);
        binaryPromotionOperators.add(JavaTokenType.PERC);
        binaryPromotionOperators.add(JavaTokenType.PLUS);
        binaryPromotionOperators.add(JavaTokenType.MINUS);
        binaryPromotionOperators.add(JavaTokenType.LT);
        binaryPromotionOperators.add(JavaTokenType.LE);
        binaryPromotionOperators.add(JavaTokenType.GT);
        binaryPromotionOperators.add(JavaTokenType.GE);
        binaryPromotionOperators.add(JavaTokenType.EQEQ);
        binaryPromotionOperators.add(JavaTokenType.NE);
        binaryPromotionOperators.add(JavaTokenType.AND);
        binaryPromotionOperators.add(JavaTokenType.XOR);
        binaryPromotionOperators.add(JavaTokenType.OR);
    }

    private static class UnnecessaryExplicitNumericCastVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryExplicitNumericCastVisitor() {
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiType castType = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType operandType = operand2.getType();
            if (castType.equals(operandType) || UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(expression2)) {
                return;
            }
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement != null) {
                this.registerError((PsiElement)typeElement, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{operand2});
            }
        }
    }

    private static class UnnecessaryExplicitNumericCastFix
    extends InspectionGadgetsFix {
        private UnnecessaryExplicitNumericCastFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            if (UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(typeCastExpression)) {
                return;
            }
            PsiExpression operand2 = typeCastExpression.getOperand();
            if (operand2 == null) {
                typeCastExpression.delete();
            } else {
                typeCastExpression.replace((PsiElement)operand2);
            }
        }
    }
}

