/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyDirectoryInspection
extends BaseGlobalInspection {
    public boolean onlyReportDirectoriesUnderSourceRoots = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("empty.directory.display.name", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("empty.directories.only.under.source.roots.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportDirectoriesUnderSourceRoots");
    }

    public boolean isGraphNeeded() {
        return false;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext context, @NotNull ProblemDescriptionsProcessor processor2) {
        Project project2 = context.getProject();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        SearchScope searchScope = scope.toSearchScope();
        if (!(searchScope instanceof GlobalSearchScope)) {
            return;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        index.iterateContent(fileOrDir -> {
            if (!fileOrDir.isDirectory()) {
                return true;
            }
            if (!globalSearchScope.contains(fileOrDir)) {
                return true;
            }
            if (this.onlyReportDirectoriesUnderSourceRoots && !index.isInSourceContent(fileOrDir)) {
                return true;
            }
            VirtualFile[] children2 = fileOrDir.getChildren();
            if (children2.length != 0) {
                return true;
            }
            PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> psiManager.findDirectory(fileOrDir));
            RefElement refDirectory = context.getRefManager().getReference((PsiElement)directory);
            if (refDirectory == null || context.shouldCheck((RefEntity)refDirectory, (GlobalInspectionTool)this)) {
                return true;
            }
            String relativePath = EmptyDirectoryInspection.getPathRelativeToModule(fileOrDir, project2);
            if (relativePath == null) {
                return true;
            }
            processor2.addProblemElement((RefEntity)refDirectory, new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("empty.directories.problem.descriptor", relativePath), new QuickFix[]{new EmptyPackageFix(fileOrDir.getUrl(), fileOrDir.getName())})});
            return true;
        });
    }

    @Nullable
    private static String getPathRelativeToModule(VirtualFile file2, Project project2) {
        VirtualFile[] contentRoots;
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
        for (VirtualFile otherRoot : contentRoots = (VirtualFile[])ReadAction.compute(() -> rootManager.getContentRootsFromAllModules())) {
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)file2, (boolean)false)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)otherRoot, (char)'/');
        }
        return null;
    }

    private static class EmptyPackageFix
    implements QuickFix {
        private final String url;
        private final String name;

        public EmptyPackageFix(String url, String name) {
            this.url = url;
            this.name = name;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("empty.directories.delete.quickfix", this.name);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("empty.directories.delete.quickfix", "");
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.url);
            if (file2 == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiDirectory directory = psiManager.findDirectory(file2);
            if (directory == null) {
                return;
            }
            directory.delete();
        }
    }
}

