/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BoxingBoxedValueInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> boxedPrimitiveMap = new HashMap<String, String>(8);

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("boxing.boxed.value.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("boxing.boxed.value.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new BoxingBoxedValueFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BoxingBoxedValueVisitor();
    }

    static {
        boxedPrimitiveMap.put("java.lang.Integer", "int");
        boxedPrimitiveMap.put("java.lang.Short", "short");
        boxedPrimitiveMap.put("java.lang.Boolean", "boolean");
        boxedPrimitiveMap.put("java.lang.Long", "long");
        boxedPrimitiveMap.put("java.lang.Byte", "byte");
        boxedPrimitiveMap.put("java.lang.Float", "float");
        boxedPrimitiveMap.put("java.lang.Double", "double");
        boxedPrimitiveMap.put("java.lang.Character", "char");
    }

    private static class BoxingBoxedValueVisitor
    extends BaseInspectionVisitor {
        private BoxingBoxedValueVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType constructorType = expression2.getType();
            if (constructorType == null) {
                return;
            }
            String constructorTypeText = constructorType.getCanonicalText();
            if (!boxedPrimitiveMap.containsKey(constructorTypeText)) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter parameter = parameters2[0];
            PsiType parameterType = parameter.getType();
            String parameterTypeText = parameterType.getCanonicalText();
            String boxableConstructorType = boxedPrimitiveMap.get(constructorTypeText);
            if (!boxableConstructorType.equals(parameterTypeText)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            String argumentTypeText = argumentType.getCanonicalText();
            if (!constructorTypeText.equals(argumentTypeText)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (className == null) {
                return;
            }
            if (!boxedPrimitiveMap.containsKey(className)) {
                return;
            }
            if (method2.getParameterList().getParametersCount() != 1) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            String argumentTypeText = argumentType.getCanonicalText();
            if (!className.equals(argumentTypeText)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }
    }

    private static class BoxingBoxedValueFix
    extends InspectionGadgetsFix {
        private BoxingBoxedValueFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("boxing.boxed.value.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiCallExpression parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class});
            if (parent == null) {
                return;
            }
            parent.replace(element);
        }
    }
}

