/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class InstantiatingObjectToGetClassObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InstantiatingObjectToGetClassObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstantiatingObjectToGetClassObjectVisitor();
    }

    private static class InstantiatingObjectToGetClassObjectVisitor
    extends BaseInspectionVisitor {
        private InstantiatingObjectToGetClassObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getClass".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            if (newExpression.getAnonymousClass() != null) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class InstantiatingObjectToGetClassObjectFix
    extends InspectionGadgetsFix {
        private InstantiatingObjectToGetClassObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("instantiating.object.to.get.class.object.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, InstantiatingObjectToGetClassObjectFix.getTypeText(type2, new StringBuilder()) + ".class");
        }

        private static StringBuilder getTypeText(PsiType type2, StringBuilder text) {
            if (type2 instanceof PsiArrayType) {
                text.append("[]");
                PsiArrayType arrayType = (PsiArrayType)type2;
                InstantiatingObjectToGetClassObjectFix.getTypeText(arrayType.getComponentType(), text);
            } else if (type2 instanceof PsiClassType) {
                String canonicalText = type2.getCanonicalText();
                String typeText = StringUtils.stripAngleBrackets(canonicalText);
                text.insert(0, typeText);
            } else {
                text.insert(0, type2.getCanonicalText());
            }
            return text;
        }
    }
}

