/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayToCollectionCopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("manual.array.to.collection.copy.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("manual.array.to.collection.copy.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ManualArrayToCollectionCopyFix();
    }

    private static PsiArrayAccessExpression getArrayAccessExpression(PsiForStatement forStatement) {
        PsiExpression arrayAccessExpression;
        PsiStatement body2 = ManualArrayToCollectionCopyInspection.getBody((PsiLoopStatement)forStatement);
        if (body2 == null) {
            return null;
        }
        if (body2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            arrayAccessExpression = expressions2.length == 0 ? null : expressions2[0];
        } else if (body2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body2;
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiVariable)) {
                return null;
            }
            PsiVariable variable = (PsiVariable)declaredElement;
            arrayAccessExpression = variable.getInitializer();
        } else {
            return null;
        }
        PsiExpression deparenthesizedArgument = ParenthesesUtils.stripParentheses(arrayAccessExpression);
        if (!(deparenthesizedArgument instanceof PsiArrayAccessExpression)) {
            return null;
        }
        return (PsiArrayAccessExpression)deparenthesizedArgument;
    }

    @Nullable
    private static PsiStatement getBody(PsiLoopStatement forStatement) {
        PsiStatement body2 = forStatement.getBody();
        while (body2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            body2 = statements.length == 0 ? null : statements[0];
        }
        return body2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayToCollectionCopyVisitor();
    }

    private static class ManualArrayToCollectionCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayToCollectionCopyVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiStatement initialization = statement2.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiExpression condition2 = statement2.getCondition();
            if (!ExpressionUtils.isVariableLessThanComparison(condition2, (PsiVariable)variable)) {
                return;
            }
            PsiStatement update2 = statement2.getUpdate();
            if (!VariableAccessUtils.variableIsIncremented((PsiVariable)variable, update2)) {
                return;
            }
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(statement2);
            if (arrayAccessExpression == null) {
                return;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type2 = arrayExpression.getType();
            if (!(type2 instanceof PsiArrayType) || type2.getDeepComponentType() instanceof PsiPrimitiveType) {
                return;
            }
            PsiStatement body2 = statement2.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body2, (PsiVariable)variable, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            PsiExpression iteratedValue2 = statement2.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            PsiType type2 = iteratedValue2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                return;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            PsiStatement body2 = statement2.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body2, (PsiVariable)parameter, false)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        private static boolean bodyIsArrayToCollectionCopy(PsiStatement body2, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if (body2 instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body2;
                PsiExpression expression2 = expressionStatement.getExpression();
                return ManualArrayToCollectionCopyVisitor.expressionIsArrayToCollectionCopy(expression2, variable, shouldBeOffsetArrayAccess);
            }
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[0], variable, shouldBeOffsetArrayAccess);
                }
                if (statements.length == 2) {
                    PsiStatement statement2 = statements[0];
                    if (!(statement2 instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer, variable)) {
                        return false;
                    }
                    return ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[1], localVariable, false);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayToCollectionCopy(PsiExpression expression2, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return false;
            }
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType instanceof PsiPrimitiveType) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(argument)) {
                return false;
            }
            if (shouldBeOffsetArrayAccess ? !ExpressionUtils.isOffsetArrayAccess(argument, variable) : !VariableAccessUtils.evaluatesToVariable(argument, variable)) {
                return false;
            }
            PsiMethod method2 = methodCallExpression.resolveMethod();
            if (method2 == null) {
                return false;
            }
            String name = method2.getName();
            if (!name.equals("add")) {
                return false;
            }
            PsiClass containingClass = method2.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection");
        }
    }

    private static class ManualArrayToCollectionCopyFix
    extends InspectionGadgetsFix {
        private ManualArrayToCollectionCopyFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("manual.array.to.collection.copy.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(forStatement);
                if (newExpression == null) {
                    return;
                }
                PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)forStatement, newExpression);
            } else {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(foreachStatement);
                if (newExpression == null) {
                    return;
                }
                PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)foreachStatement, newExpression);
            }
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForeachStatement foreachStatement) throws IncorrectOperationException {
            PsiStatement body2 = ManualArrayToCollectionCopyInspection.getBody((PsiLoopStatement)foreachStatement);
            if (!(body2 instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body2;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expressionStatement.getExpression();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement collection = methodExpression.getQualifier();
            if (collection == null) {
                return null;
            }
            String collectionText = collection.getText();
            PsiExpression iteratedValue2 = foreachStatement.getIteratedValue();
            if (iteratedValue2 == null) {
                return null;
            }
            String arrayText = iteratedValue2.getText();
            StringBuilder buffer = new StringBuilder();
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)foreachStatement)) {
                buffer.append("java.util.Collections.addAll(");
                buffer.append(collectionText);
                buffer.append(',');
                buffer.append(arrayText);
                buffer.append(");");
            } else {
                buffer.append(collectionText);
                buffer.append(".addAll(java.util.Arrays.asList(");
                buffer.append(arrayText);
                buffer.append("));");
            }
            return buffer.toString();
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForStatement forStatement) throws IncorrectOperationException {
            PsiExpression expression2 = forStatement.getCondition();
            PsiBinaryExpression condition2 = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(expression2);
            if (condition2 == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            String collectionText = ManualArrayToCollectionCopyFix.buildCollectionText(forStatement);
            PsiArrayAccessExpression arrayAccessExpression = ManualArrayToCollectionCopyInspection.getArrayAccessExpression(forStatement);
            if (arrayAccessExpression == null) {
                return null;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String arrayText = arrayExpression.getText();
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            String indexOffset = ManualArrayToCollectionCopyFix.getIndexOffset(indexExpression, variable);
            if (indexOffset == null) {
                return null;
            }
            String fromOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(variable.getInitializer(), indexOffset, false);
            if (fromOffsetText == null) {
                return null;
            }
            IElementType tokenType = condition2.getOperationTokenType();
            PsiExpression limit = tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE ? condition2.getROperand() : condition2.getLOperand();
            String toOffsetText = ManualArrayToCollectionCopyFix.addIndexOffset(limit, indexOffset, tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GE);
            if (toOffsetText == null) {
                return null;
            }
            if (fromOffsetText.equals("0") && toOffsetText.equals(arrayText + ".length") && PsiUtil.isLanguageLevel5OrHigher((PsiElement)forStatement)) {
                return "java.util.Collections.addAll(" + collectionText + ',' + arrayText + ");";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(collectionText);
            buffer.append('.');
            buffer.append("addAll(java.util.Arrays.asList(");
            buffer.append(arrayText);
            buffer.append(')');
            if (!fromOffsetText.equals("0") || !toOffsetText.equals(arrayText + ".length")) {
                buffer.append(".subList(");
                buffer.append(fromOffsetText);
                buffer.append(", ");
                buffer.append(toOffsetText);
                buffer.append(')');
            }
            buffer.append(");");
            return buffer.toString();
        }

        public static String buildCollectionText(PsiForStatement forStatement) {
            PsiStatement body2 = forStatement.getBody();
            while (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body2 = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body2 = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body2 instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return null;
            }
            return qualifier.getText();
        }

        @Nullable
        private static String getIndexOffset(PsiExpression expression2, PsiLocalVariable variable) {
            String variableName;
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return null;
            }
            if (ExpressionUtils.isZero(expression2)) {
                return "0";
            }
            String expressionText = expression2.getText();
            if (expressionText.equals(variableName = variable.getName())) {
                return "0";
            }
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayToCollectionCopyFix.getIndexOffset(rhs, variable);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                String lhsText = ManualArrayToCollectionCopyFix.getIndexOffset(lhs, variable);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayToCollectionCopyFix.collapseConstant(lhsText + " " + sign.getText() + " " + rhsText, (PsiElement)variable);
            }
            return ManualArrayToCollectionCopyFix.collapseConstant(expressionText, (PsiElement)variable);
        }

        private static String addIndexOffset(PsiExpression expression2, String indexOffset, boolean plusOne) {
            if (expression2 == null) {
                return null;
            }
            if (plusOne) {
                indexOffset = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") + 1", (PsiElement)expression2);
            }
            String expressionText = expression2.getText();
            if ("0".equals(indexOffset)) {
                return expressionText;
            }
            if (expression2 instanceof PsiBinaryExpression) {
                Object lhConstant;
                Object rhConstant;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (tokenType == JavaTokenType.PLUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant(rhConstant + " + (" + indexOffset + ")", (PsiElement)expression2);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, (PsiElement)expression2);
                }
                if (tokenType == JavaTokenType.MINUS && (rhConstant = ExpressionUtils.computeConstantExpression(rhs)) != null) {
                    String rhText = ManualArrayToCollectionCopyFix.collapseConstant("(" + indexOffset + ") - " + rhConstant, (PsiElement)expression2);
                    if ("0".equals(rhText)) {
                        return lhs.getText();
                    }
                    return lhs.getText() + ManualArrayToCollectionCopyFix.getAddendum(rhText, (PsiElement)expression2);
                }
                if (rhs != null && (tokenType == JavaTokenType.PLUS || tokenType == JavaTokenType.MINUS) && (lhConstant = ExpressionUtils.computeConstantExpression(lhs)) != null) {
                    String lhText = ManualArrayToCollectionCopyFix.collapseConstant(lhConstant + " + (" + indexOffset + ")", (PsiElement)expression2);
                    if ("0".equals(lhText)) {
                        return tokenType == JavaTokenType.MINUS ? "-" + rhs.getText() : rhs.getText();
                    }
                    return lhText + (tokenType == JavaTokenType.MINUS ? " - " : " + ") + rhs.getText();
                }
            }
            String addendum = ManualArrayToCollectionCopyFix.getAddendum(indexOffset, (PsiElement)expression2);
            int precedence = ParenthesesUtils.getPrecedence(expression2);
            String text = precedence > 6 ? '(' + expressionText + ")" + addendum : expressionText + addendum;
            return ManualArrayToCollectionCopyFix.collapseConstant(text, (PsiElement)expression2);
        }

        private static String getAddendum(String expressionText, PsiElement context) {
            if (expressionText.startsWith("-")) {
                String negatedExpressionText = expressionText.substring(1);
                Object lhConstant = ManualArrayToCollectionCopyFix.computeConstant(negatedExpressionText, context);
                if (lhConstant != null) {
                    return " - " + lhConstant.toString();
                }
                return " + (" + expressionText + ")";
            }
            return " + " + expressionText;
        }

        private static String collapseConstant(String expressionText, PsiElement context) throws IncorrectOperationException {
            Object fromOffsetConstant = ManualArrayToCollectionCopyFix.computeConstant(expressionText, context);
            return fromOffsetConstant != null ? fromOffsetConstant.toString() : expressionText;
        }

        private static Object computeConstant(String expressionText, PsiElement context) {
            Project project2 = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            return ExpressionUtils.computeConstantExpression(fromOffsetExpression);
        }
    }
}

