/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class MapReplaceableByEnumMapInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("map.replaceable.by.enum.map.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("map.replaceable.by.enum.map.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetReplaceableByEnumSetVisitor();
    }

    private static class SetReplaceableByEnumSetVisitor
    extends BaseInspectionVisitor {
        private SetReplaceableByEnumSetVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiExpression[] arguments;
            PsiMember member;
            PsiType[] typeArguments;
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            if (!classType.hasParameters()) {
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false);
                if (!(expectedType instanceof PsiClassType)) {
                    return;
                }
                classType = (PsiClassType)expectedType;
            }
            if ((typeArguments = classType.getParameters()).length != 2) {
                return;
            }
            PsiType argumentType = typeArguments[0];
            if (!(argumentType instanceof PsiClassType)) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.Map")) {
                return;
            }
            if (null != TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.EnumMap", "java.util.concurrent.ConcurrentMap")) {
                return;
            }
            PsiClassType argumentClassType = (PsiClassType)argumentType;
            PsiClass argumentClass = argumentClassType.resolve();
            if (argumentClass == null || !argumentClass.isEnum()) {
                return;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
            if (argumentClass.equals(aClass) && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class)) != null && !member.hasModifierProperty("static")) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList != null && (arguments = argumentList.getExpressions()).length > 0 && TypeUtils.expressionHasTypeOrSubtype(arguments[0], "java.util.Comparator")) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

