/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SetReplaceableByEnumSetInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("set.replaceable.by.enum.set.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("set.replaceable.by.enum.set.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetReplaceableByEnumSetVisitor();
    }

    private static class SetReplaceableByEnumSetVisitor
    extends BaseInspectionVisitor {
        private SetReplaceableByEnumSetVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            if (!classType.hasParameters()) {
                return;
            }
            PsiType[] typeArguments = classType.getParameters();
            if (typeArguments.length != 1) {
                return;
            }
            PsiType argumentType = typeArguments[0];
            if (!(argumentType instanceof PsiClassType)) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.Set")) {
                return;
            }
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.EnumSet")) {
                return;
            }
            PsiClassType argumentClassType = (PsiClassType)argumentType;
            PsiClass argumentClass = argumentClassType.resolve();
            if (argumentClass == null) {
                return;
            }
            if (!argumentClass.isEnum()) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

