/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferMustHaveInitialCapacityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "StringBufferWithoutInitialCapacity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.buffer.must.have.initial.capacity.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.buffer.must.have.initial.capacity.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferInitialCapacityVisitor();
    }

    private static class StringBufferInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private StringBufferInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type2) && !TypeUtils.typeEquals("java.lang.StringBuilder", type2)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

