/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferToStringInConcatenationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferToStringVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringBufferToStringFix();
    }

    private static class StringBufferToStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferToStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ExpressionUtils.isStringConcatenationOperand((PsiExpression)expression2)) {
                return;
            }
            if (!StringBufferToStringVisitor.isStringBufferToString(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isStringBufferToString(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return false;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return false;
            }
            PsiParameterList parameterList = method2.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return false;
            }
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className);
        }
    }

    private static class StringBufferToStringFix
    extends InspectionGadgetsFix {
        private StringBufferToStringFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameToken = descriptor.getPsiElement();
            PsiElement methodCallExpression = methodNameToken.getParent();
            assert (methodCallExpression != null);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodCallExpression.getParent();
            assert (methodCall != null);
            PsiReferenceExpression expression2 = methodCall.getMethodExpression();
            PsiExpression qualifier = expression2.getQualifierExpression();
            assert (qualifier != null);
            String newExpression = qualifier.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, newExpression);
        }
    }
}

