/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInsideStringBufferAppendInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        return InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.problem.descriptor", className);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInsideStringBufferAppendVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceWithChainedAppendFix();
    }

    private static class StringConcatenationInsideStringBufferAppendVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInsideStringBufferAppendVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!ExpressionUtils.isConcatenation((PsiElement)ParenthesesUtils.stripParentheses(argument)) || PsiUtil.isConstantExpression((PsiExpression)argument)) {
                return;
            }
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 == null) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                this.registerMethodCallError(expression2, containingClass);
                return;
            }
            Project project2 = containingClass.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass appendableClass = psiFacade.findClass("java.lang.Appendable", GlobalSearchScope.allScope((Project)project2));
            if (appendableClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)appendableClass, (boolean)true)) {
                return;
            }
            this.registerMethodCallError(expression2, containingClass);
        }
    }

    private static class ReplaceWithChainedAppendFix
    extends InspectionGadgetsFix {
        private ReplaceWithChainedAppendFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
            if (methodCallExpression == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = ct.markUnchanged(arguments[0]);
            PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(qualifier, argument);
            if (appendExpression == null) {
                return;
            }
            ct.replaceAndRestoreComments((PsiElement)methodCallExpression, (PsiElement)appendExpression);
        }
    }
}

