/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConstructorInspection
extends BaseInspection {
    public boolean ignoreSubstringArguments = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.constructor.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "RedundantStringConstructorCall";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.constructor.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.constructor.substring.parameter.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSubstringArguments");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean noArguments = (Boolean)infos[0];
        return new StringConstructorFix(noArguments);
    }

    private class StringConstructorVisitor
    extends BaseInspectionVisitor {
        private StringConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            if (arguments.length == 1) {
                PsiExpression argument = arguments[0];
                PsiType parameterType = argument.getType();
                if (!TypeUtils.isJavaLangString(parameterType)) {
                    return;
                }
                if (StringConstructorInspection.this.ignoreSubstringArguments && this.hasSubstringArgument(argument)) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, arguments.length == 0);
        }

        private boolean hasSubstringArgument(PsiExpression argument) {
            if (!(argument instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)argument;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method2 = (PsiMethod)element;
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            String methodName = method2.getName();
            return "java.lang.String".equals(className) && methodName.equals("substring");
        }
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private StringConstructorFix(boolean noArguments) {
            this.m_name = noArguments ? InspectionGadgetsBundle.message("string.constructor.replace.empty.quickfix", new Object[0]) : InspectionGadgetsBundle.message("string.constructor.replace.arg.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiNewExpression expression2 = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression2.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            String argText = args.length == 1 ? args[0].getText() : "\"\"";
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, argText);
        }
    }
}

