/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ToArrayCallWithZeroLengthArrayArgumentInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[1];
        return InspectionGadgetsBundle.message("to.array.call.with.zero.length.array.argument.problem.descriptor", argument.getText());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ToArrayCallWithZeroLengthArrayArgument();
    }

    private static class ToArrayCallWithZeroLengthArrayArgument
    extends BaseInspectionVisitor {
        private ToArrayCallWithZeroLengthArrayArgument() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiMethod method2;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type2 = argument.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            if (type2.getArrayDimensions() != 1) {
                return;
            }
            if (argument instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field = (PsiField)element;
                if (!CollectionUtils.isConstantEmptyArray(field)) {
                    return;
                }
            } else if (!ConstructionUtils.isEmptyArrayInitializer(argument)) {
                return;
            }
            if ((method2 = expression2.resolveMethod()) == null) {
                return;
            }
            PsiClass containingClass = method2.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) {
                return;
            }
            this.registerMethodCallError(expression2, expression2, argument);
        }
    }
}

