/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TrivialStringConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ConcatenationWithEmptyString";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("trivial.string.concatenation.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("trivial.string.concatenation.problem.descriptor", new Object[0]);
    }

    @NonNls
    static String calculateReplacementExpression(PsiLiteralExpression expression2) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
        if (!(parent instanceof PsiPolyadicExpression)) {
            return null;
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            PsiExpression lOperand = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rOperand = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            PsiExpression replacement = ExpressionUtils.isEmptyStringLiteral(lOperand) ? rOperand : lOperand;
            return replacement == null ? "" : TrivialStringConcatenationInspection.buildReplacement(replacement, false);
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)expression2);
        boolean seenString = false;
        boolean seenEmpty = false;
        boolean replaced = false;
        PsiExpression operandToReplace = null;
        StringBuilder text = new StringBuilder();
        for (PsiExpression operand2 : operands2) {
            if (operandToReplace != null && !replaced) {
                if (ExpressionUtils.hasStringType(operand2)) {
                    seenString = true;
                }
                if (text.length() > 0) {
                    text.append(" + ");
                }
                text.append(TrivialStringConcatenationInspection.buildReplacement(operandToReplace, seenString));
                text.append(" + ");
                text.append(operand2.getText());
                replaced = true;
                continue;
            }
            if (ParenthesesUtils.stripParentheses(operand2) == expression2) {
                seenEmpty = true;
                continue;
            }
            if (seenEmpty && !replaced) {
                operandToReplace = operand2;
                continue;
            }
            if (stringType.equals((Object)operand2.getType())) {
                seenString = true;
            }
            if (text.length() > 0) {
                text.append(" + ");
            }
            text.append(operand2.getText());
        }
        if (!replaced && operandToReplace != null) {
            text.append(" + ");
            text.append(TrivialStringConcatenationInspection.buildReplacement(operandToReplace, seenString));
        }
        return text.toString();
    }

    @NonNls
    static String buildReplacement(@NotNull PsiExpression operandToReplace, boolean seenString) {
        if (ExpressionUtils.isNullLiteral(operandToReplace)) {
            if (seenString) {
                return "null";
            }
            return "String.valueOf((Object)null)";
        }
        if (seenString || ExpressionUtils.hasStringType(operandToReplace)) {
            return operandToReplace.getText();
        }
        return "String.valueOf(" + operandToReplace.getText() + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryTemporaryObjectFix((PsiLiteralExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialStringConcatenationVisitor();
    }

    private static class TrivialStringConcatenationVisitor
    extends BaseInspectionVisitor {
        private TrivialStringConcatenationVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2;
            super.visitPolyadicExpression(expression2);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression2)) {
                return;
            }
            for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
                if ((operand2 = ParenthesesUtils.stripParentheses(operand2)) == null) {
                    return;
                }
                if (!ExpressionUtils.isEmptyStringLiteral(operand2)) continue;
                if (PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                    return;
                }
                this.registerError((PsiElement)operand2, operand2);
            }
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(PsiLiteralExpression expression2) {
            this.m_name = InspectionGadgetsBundle.message("string.replace.quickfix", TrivialStringConcatenationInspection.calculateReplacementExpression(expression2));
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @NotNull
        public String getFamilyName() {
            return "Replace concatenation";
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)descriptor.getPsiElement();
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (!(parent instanceof PsiExpression)) {
                return;
            }
            String newExpression = TrivialStringConcatenationInspection.calculateReplacementExpression(expression2);
            PsiReplacementUtil.replaceExpression((PsiExpression)parent, newExpression);
        }
    }
}

